# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.utils.bemhtml import punctuate_content
from common.utils.date import DateTimeFormatter, human_date
from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xngettext, xgettext, dynamic_gettext

from travel.rasp.morda.morda.utils.locations import tablo_link

# Шаблоны
from .base import Template as Base
from ..utils import json_dt_struct, segment_strong_number, wrap_with_link
from ..timetable import TimeWithDateIfChangedFormatter, segment_description


class Template(Base):
    page = 'tablo'

    def b_datelinks(self):

        json_links = []
        for j, name in enumerate([ gettext('вчера'), gettext('сегодня'), gettext('завтра') ]):
            day = j - 1
            current = self.context.slider.day == day
            item = {
                'elem': 'item',
                'content': {
                    'block': 'b-slider-link',
                    'mods': { 'state': 'current' if current else '' },
                    'js': { 'day': str(day) },
                    'content': [
                        {
                            'block': 'b-link',
                            'mix': [{
                                'block': 'b-slider-link',
                                'elem': 'link'
                            } ],
                            'url': self.context.slider.links[j],
                            'content': name,
                            'cls': current and 'i-hidden' or ''
                        },
                        {
                            'elem': 'text',
                            'content': name,
                            'cls': not current and 'i-hidden' or ''
                        }
                    ]
                }
            }

            json_links.append(item)

        return {
            'block': 'b-menu',
            'mods': {'layout': 'horiz', 'preset': 'date-links'},
            'content': json_links
        }

    def b_short_search(self):
        return {
            'block': 'b-short-search',
            'attrs': { 'action': '' },
            'mods': { 'type': 'tablo' },
            'js': True,
            'content': {
                'block': 'b-layout-table',
                'mods': { 'layout': 'short-search' },
                'content': {
                    'elem': 'row',
                    'content': [
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'search' },
                            'content': {
                                'block': 'b-form-input',
                                'mods': {
                                    'size': 's',
                                    'theme': 'grey',
                                    'has-clear': 'yes',
                                    'autocomplete': 'yes',
                                },
                                'value': self.context.query,
                                'tabindex': 5,
                                'name': 'suggest',
                                'attrs': { 'id': 'id2668815' },
                                'js': {
                                    'dataprovider': {
                                        'url': '/suggests/tablo/%s/?event=%s&callback=?' % (self.context.station.id, self.context.event),
                                    },
                                    'popupMods': { 'minwidth': 'small' },
                                    'debounceDelay': 100,
                                },
                                'content': [
                                    { 'elem': 'hint', 'content': '' },
                                    { 'elem': 'input', 'clear': { 'elem': 'clear' }, 'attrs': { 'tabindex': 5 } }
                                ]
                            }
                        },
                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'button' },
                            'content': {
                                'block': 'b-form-button',
                                'mods': { 'size': 's', 'theme': 'grey-s' },
                                'tabindex': 6,
                                'type': 'submit',
                                'content': gettext('Найти')
                            }
                        }
                    ]
                }
            }
        }

    def b_timetable_slider_scale(self):
        if not self.context.slider:
            return None

        def scale_items():
            for j, scale_item in enumerate(self.context.slider.scale):
                hours_data, density = scale_item
                hour_mark, day = hours_data
                yield j + 1, hour_mark, day, density

        return {
            'block': 'b-timetable-slider',
            'elem': 'scale',
            'js': True,
            'content': {
                'elem': 'lines',
                'content': [
                    {
                        'elem': 'line',
                        'elemMods': {'type': day and 'day', 'position': str(loop_index)},
                        'content': [
                            {
                                'elem': 'sep'
                            },
                            {
                                'elem': 'day',
                                'content': day and human_date(day)
                            },
                            {
                                'elem': 'time',
                                'content': hour_mark
                            }
                        ]
                    } for loop_index, hour_mark, day, density in scale_items()
                ]
            }
        }

    def slider_js_params(self):
        if not self.context.slider:
            return []

        slider = self.context.slider
        tz_cities = self.context.tz_cities
        return {
            'now': json_dt_struct(slider.now, tz_cities),
            'limits': [
                json_dt_struct(slider.limits[0], tz_cities),
                json_dt_struct(slider.limits[1], tz_cities)
            ],
            'scale': {
                'start': slider.start.strftime('%B %d, %Y %H:%M:%S'),
                'current': json_dt_struct(slider.current, tz_cities),
                'span': slider.span,
            },
        }

    def b_timetable_slider(self):
        if not self.context.slider:
            return []

        slider = self.context.slider

        return {
            'block': 'b-timetable-slider',
            'js': self.slider_js_params(),
            'content': [
                self.b_timetable_slider_scale(),
                {
                    'elem': 'timeline'
                },
                {
                    'elem': 'slider',
#                    'elemMods': {'state': 'busy'},
                    'attrs': {'style': 'left: %s%%; width: %s%%;' % (slider.position, slider.width)},
                    'content': [
                        {
                            'elem': 'tack',
                            'elemMods': {'type': 'left'}
                        },
                        {
                            'elem': 'tack',
                            'elemMods': {'type': 'right'}
                        }
                    ]
                }
            ]
        }


    def hrows(self):
        context = self.context
        station = context.station

        add_td = True
        if station.tablo_state == 'statuses':
            tz_columns_amount = 1
        elif station.tablo_state == 'real':
            tz_columns_amount = 2
        else:
            tz_columns_amount = 1
            if station.t_type_id != 2:
                add_td = False

        type_one = bool(context.date) or tz_columns_amount == 1

        return [
            {
                'elem': 'hrow',
                'content': [
                    { 'elem': 'cell' },
                    { 'elem': 'cell' },
                    self.context.show_terminals and { 'elem': 'cell' } or '',
                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'timeselector' },
                        'attrs': { 'colspan': str(tz_columns_amount - 1) or tz_columns_amount },
                        'content': {
                            'block': 'b-timeselector',
                            'mods': { 'type': type_one and 'one' or '' },
                            'content': [
                                {
                                    'elem': 'selector',
                                    'elemMods': { 'size': 'small' },
                                    'content': [
                                        {
                                            'block': 'b-icon'
                                        },
                                        self.timeselector(),
                                    ]
                                },
                                not type_one and { 'elem': 'line' } or ''
                            ]
                        }
                    },
                    tz_columns_amount > 1 and { 'elem': 'cell' } or '',
                    add_td and { 'elem': 'cell' } or ''
                ]
            },
            {
                'elem': 'hrow',
                'elemMods': { 'position': 'last' },
                'content': [

                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'tablo-trip' },
                        'attrs': { 'colspan': 2 },
                        'content': gettext('рейс')
                    },

                    self.context.show_terminals and {
                        'elem': 'cell',
                        'elemMods': { 'type': 'terminal' },
                        'content': gettext('терминал')
                    } or '',

                    station.tablo_state == 'statuses' and [

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'schedule', 'state': 'current', 'sort': 'desc' },
                            'content': gettext('расписание')
                        },

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'status' },
                            'content': gettext('статус')
                        },

                    ] or station.tablo_state == 'real' and [

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'schedule', 'state': 'current', 'sort': 'desc' },
                            'content': gettext('расписание')
                        },

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'expected-time' },
                            'content': gettext('ожидаемое время')
                        },

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'status' },
                            'content': gettext('статус')
                        },

                    ] or [

                        {
                            'elem': 'cell',
                            'elemMods': { 'type': 'expected-time' },
                            'content': gettext('время')
                        },

                        station.t_type_id == 2 and {
                            'elem': 'cell',
                            'elemMods': { 'type': 'status' },
                            'content': gettext('статус')
                        },

                    ]
                ]
            },
        ]

    def rows(self):
        context = self.context
        station = context.station
        routes = context.routes

        if station.tablo_state:
            columns = 5
        else:
            columns = 4

        if self.context.show_terminals:
            columns = columns + 1

        if routes:
            json_rows = []

            if self.context.query:
                json_rows.append({
                    'elem': 'row',
                    'content': {
                        'elem': 'cell',
                        'elemMods': { 'type': 'filter-alert' },
                        'attrs': { 'colspan': str(columns) },
                        'content': [
                            {
                                'elem': 'showtext',
                                'tag': 'span',
                                'content': xngettext(
                                    len(routes),
                                    'Показан <n/> рейс из <all/>',
                                    'Показано <n/> рейса из <all/>',
                                    'Показано <n/> рейсов из <all/>',
                                    all=self.context.routes_amount,
                                )
                            },
                            { 'block': 'b-form-button', 'mods': { 'type': 'simple', 'theme': 'simple-silver', 'size': 's' }, 'content': gettext('Показать все') }
                        ]
                    }
                })

            json_rows.extend(self.tablo_rows(routes))

            return json_rows

        else:
            return [
                self.context.query and {
                    'elem': 'row',
                    'content': {
                        'elem': 'cell',
                        'elemMods': { 'type': 'filter-noresult' },
                        'attrs': { 'colspan': str(columns) },
                        'content': [
                            { 'elem': 'filter-noresult', 'content': gettext('Рейсы не найдены') },
                            { 'block': 'b-form-button', 'mods': { 'type': 'simple', 'size': 's' }, 'content': gettext('Показать табло') }
                        ]
                    }
                } or {
                    'elem': 'row',
                    'content': {
                        'elem': 'cell',
                        'attrs': { 'colspan': str(columns) },
                        'content': self.context.message
                    }
                }
            ]

    def tablo_rows(self, routes):
        time_formatter = TimeWithDateIfChangedFormatter(self)
        rasp_formatter = TimeWithDateIfChangedFormatter(self)

        count = len(routes)

        for i, z_tablo in enumerate(routes):
            last = i + 1 == count

            mods = {}

            if last:
                mods['position'] = 'last'

            status_code = z_tablo.status_code

            status = dynamic_gettext(z_tablo.status)

            # Сссылка на рейс
            url = tablo_link(z_tablo, self.context.request)

            yield {
                'elem': 'row',
                'elemMods': mods,
                'content': [
                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'ico' },
                        'content': wrap_with_link({
                            'block': 'b-transico',
                            'mods': { 'type': z_tablo.display_t_code },
                            'alt': gettext('самолёт')
                        }, url)
                    },
                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'tablo-trip' },
                        'content': [
                            {
                                'elem': 'tripname',
                                'content': not url and [
                                    { 'elem': 'text', 'tag': 'strong', 'content': z_tablo.number }, ' ', z_tablo.L_title()
                                ] or [
                                    {
                                        'block': 'b-link',
                                        'url': url,
                                        'content': [segment_strong_number(z_tablo), ' ', z_tablo.L_title()]
                                    },
                                    self.context.event == 'departure' and
                                    z_tablo.next_station and
                                    z_tablo.t_type.code == 'plane' and
                                    z_tablo.next_station.settlement and
                                    z_tablo.next_station.settlement.has_many_airports and
                                    [' (', z_tablo.next_station.L_title_with_terminal(terminal=z_tablo.next_terminal), ')']
                                ]
                            },
                            {
                                'elem': 'description',
                                'content': punctuate_content(segment_description(z_tablo))
                            }
                        ]
                    },
                    self.context.show_terminals and {
                        'elem': 'cell',
                        'elemMods': { 'type': 'terminal' },
                        'content': z_tablo.terminal and z_tablo.terminal.name or ''
                    } or '',
                    {
                        'elem': 'cell',
                        'elemMods': { 'type': 'schedule' },
                        'content': [
                            time_formatter(z_tablo.event_planned_dt), ' ',
                            {
                                'elem': 'platform',
                                'content': self.station_schema_or_platform(z_tablo)
                            }
                        ]
                    },
                    self.context.station.tablo_state == 'statuses' and [
                        self.tablo_status_elem(status_code, status)
                    ] or self.context.station.tablo_state == 'real' and [
                        self.tablo_actual_time(z_tablo, rasp_formatter),
                        self.tablo_status_elem(status_code, status)
                    ] or self.context.station.t_type_id == 2 and [
                        self.tablo_status_elem('nodata', 'нет&nbsp;данных')
                    ]
                ]
            }

    def tablo_actual_time(self, z_tablo, formatter):
        if z_tablo.has_actual_dt():
            content = formatter(z_tablo.event_dt)
        else:
            content = '&nbsp;'

        return {
            'elem': 'cell',
            'elemMods': { 'type': 'schedule' },
            'content': content
        }

    def tablo_status_elem(self, status_code, status):
        return {
            'elem': 'cell',
            'elemMods': { 'type': 'status' },
            'content': [
                {
                    'elem': 'status',
                    'elemMods': { 'type': status_code },
                    'content': status
                }
            ]
        }

    def b_timetable(self):
        return {
            'block': 'b-timetable',
            'js': {
                'timecolumns': ['schedule', 'expected-time'],
            },
            'content': self.hrows() + self.rows()
        }

    @classmethod
    def ajax(cls, request, context):
        instance = cls(request, context)

        rows = instance.rows()

        for row in rows:
            row['block'] = 'b-timetable'

        return {
            'slider': instance.slider_js_params(),
            'scale_bemjson': instance.b_timetable_slider_scale(),
            'timetable_rows':  instance.render_bemjson([instance.i_global(), rows]),
        }

    def content(self):
        station = self.context.station

        if station.t_type_id == 2:
            short_search_label = gettext('Город, страна, авиакомпания или номер рейса')

        else:
            if self.context.event == 'departure':
                short_search_label = gettext('Город, конечная станция или номер')

            else:
                short_search_label = gettext('Город, начальная станция или номер')

        return [
            {
                'block': 'l-page',
                'mods': { 'layout': '72-20', 'row': 'multiple' },
                'content': [
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'gap'
                            },
                            {
                                'elem': 'left',
                                'content': {
                                    'block': 'b-page-title',
                                    'content': [
                                        {
                                            'elem': 'title',
                                            'content': self.context.page_title
                                        },
                                        {
                                            'elem': 'contact',
                                            'content': self.contact()
                                        }
                                    ]
                                }
                            },
                            {
                                'elem': 'gap-right'
                            },
                            {
                                'elem': 'right',
                                'content': self.b_metalinks()
                            },
                            {
                                'elem': 'gap'
                            }
                        ]
                    },
                    {
                        'elem': 'row',
                        'content': [
                            {
                                'elem': 'gap'
                            },
                            {
                                'elem': 'left',
                                'content': [
                                    {
                                        'block': 'b-tablo-triggers',
                                        'content': [
                                            self.b_datelinks(),
                                            self.b_triggers(),
                                        ]
                                    },
                                    {
                                        'block': 'b-layout-table',
                                        'mods': { 'layout': 'tsearch' },
                                        'content': [
                                            {
                                                'elem': 'row',
                                                'content': [
                                                    {
                                                        'elem': 'cell',
                                                        'elemMods': { 'type': 'tabs' },
                                                        'content': {
                                                            'block': 'b-timetable-trigger',
                                                            'content': [
                                                                self.e_event_tab('departure', gettext('Отправление'), self.context.event),
                                                                self.e_event_tab('arrival', gettext('Прибытие'), self.context.event),
                                                            ]
                                                        }
                                                    },
                                                    {
                                                        'elem': 'cell',
                                                        'elemMods': { 'type': 'text' },
                                                        'content': {
                                                            'elem': 'text',
                                                            'tag': 'strong',
                                                            'content': short_search_label
                                                        }
                                                    },
                                                    {
                                                        'elem': 'cell',
                                                        'elemMods': { 'type': 'search' },
                                                        'content': self.b_short_search()
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    self.b_timetable_slider(),
                                    self.b_timetable(),
                                    {
                                        'block': 'b-description-text',
                                        'content': [
                                            {
                                                'elem': 'item',
                                                'content': station.t_type.code == 'plane'
                                                    and (station.is_foreign()
                                                            and xgettext('Расписание аэропорта <station-title/> на <date format="%d %B"/>.'
                                                                     '<br />'
                                                                     '<span class="red">Внимание!</span> '
                                                                     'Информацию по текущим статусам рейсов, отменам и опозданиям уточняйте по справочным телефонам или на официальном сайте аэропорта.',
                                                                     station_title=station.popular_title or station.title,
                                                                     date=DateTimeFormatter(self.context.slider.current.date()).L,
                                                                     br='<br/>',
                                                                     span=lambda content, **kwargs: '<span ' + ' '.join(['%s="%s"' % keyval for keyval in kwargs.items()]) + '>' + content[0] + '</span>')
                                                            or xgettext('Табло аэропорта <station_title/>&nbsp; &mdash; <date format="%d %B"/>.<br />'
                                                                     '<span class="red">Внимание!</span> '
                                                                     'Информацию по текущим статусам рейсов, отменам и опозданиям '
                                                                     '<b-link>уточняйте по справочным телефонам</b-link> '
                                                                     'или на официальном сайте аэропорта.',
                                                                     station_title=station.popular_title or station.title,
                                                                     date=DateTimeFormatter(self.context.slider.current.date()).L,
                                                                     b_link=lambda content: {
                                                                         'block': 'b-link',
                                                                         'content': content,
                                                                         'url': composeurl('info_object', args=['station', station.pk])
                                                                     },
                                                                     nbsp='&nbsp;',
                                                                     mdash='&mdash;',
                                                                     br='<br/>',
                                                                     span=lambda content, **kwargs: '<span ' + ' '.join(['%s="%s"' % keyval for keyval in kwargs.items()]) + '>' + content[0] + '</span>'))
                                                    or xgettext('Текущую ситуацию с прибытием, отправлением и опозданием поездов мы рекомендуем уточнять по справочным телефонам вокзала.')
                                            },
                                            {
                                                'elem': 'item',
                                                'cls': 'i-media-print',
                                                'content': self.b_link_place_on_my_site()
                                            }
                                        ]
                                    },
                                    self.context.counter and '<img src="//clck.yandex.ru/click/dtype=stred/pid=168/cid=%s/*http://ya.ru" />' % self.context.counter,
                                ]
                            },
                            {
                                'elem': 'gap-right'
                            },
                            {
                                'elem': 'right',
                                'content': self.right_content(),
                            },
                            {
                                'elem': 'gap'
                            }
                        ]
                    }
                ]
            }
        ]
