# -*- coding: utf-8 -*-

from utils import wrap_with_link


class TeaserRendererMixin(object):

    def render_ahtung_teaser(self, teaser):
        return {
            'block': 'b-alert',
            'content': {
                'elem': 'content',
                'content': [{
                    'block': 'b-icon',
                    'url': self.static_url(
                        'blocks-desktop/b-alert/b-alert__ico.png')
                }, {
                    'elem': 'title',
                    'content': wrap_with_link(teaser.title, teaser.url)
                }, {
                    'elem': 'text',
                    'content': teaser.content
                }]
            }
        }

    def render_ahtung_city_teaser(self, teaser):
        return [{
            'block': 'b-subtitle',
            'mods': {
                'size': 3,
                'theme': 'alarm'
            },
            'content': {
                'elem': 'title',
                'content': wrap_with_link(teaser.title, teaser.url)
            }
        }, {
            'block': 'b-alarm-text',
            'content': teaser.content
        }]

    def render_banner_teaser(self, teaser):
        return teaser.content

    def render_normal_teaser(self, teaser):
        image_url = teaser.image and teaser.image.url

        return {
            'block': 'b-rotator',
            'mix': [{'block': 'g-line'}],
            'content': [{
                'elem': 'img',
                'tag': 'img',
                'attrs': {'src': image_url}
            } if image_url else None, {
                'elem': 'title',
                'content': wrap_with_link(teaser.title, teaser.url)
            }, {
                'elem': 'text',
                'content': teaser.content
            }]
        }

    def render_special_teaser(self, teaser):
        return [{
            'block': 'b-subtitle',
            'mods': {
                'size': 3 if getattr(teaser, 'bold_mode', False) else 1,
                'theme': 'gray'
            },
            'content': {
                'elem': 'title',
                'content': wrap_with_link(teaser.title, teaser.url)
            }
        }, {
            'block': 'b-links-list',
            'content': {
                'elem': 'item',
                'content': teaser.content
            }
        }]
