# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from travel.rasp.morda.morda.templates.base import Base


class BaseTemplate(Base):
    has_filter_block = True

    def content(self):

        filter_block_content = self.has_filter_block and [
            {
                'block': 'b-menu',
                'mods': {'layout': 'horiz-complex', 'preset': 'media-links'},
                'content': [
                    {
                        'elem': 'item',
                        'content': {}
                    }
                ]
            },
            {
                'block': 'b-filter-title',
                'content': self.filter_block_title()
            },
            self.filter_block()
        ] or ''

        return {
            'block': 'l-page',
            'mods': {'layout': '72-20', 'row': 'multiple'},
            'content': [
                {
                    'elem': 'row',
                    'content': [
                        {'elem': 'gap'},
                        {
                            'elem': 'left',
                            'content': self.left_content()
                        },
                        {'elem': 'gap-right'},
                        {
                            'elem': 'right',
                            'content': [
                                filter_block_content,
                                self.teaser('ahtung')
                            ]
                        },
                        {'elem': 'gap'}
                    ]
                }
            ]
        }

    def left_content(self):
        return []

    def filter_block(self):
        pass

    def filter_block_title(self):
        return ''
