# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf.urls import include
from django.views.generic.base import RedirectView

from travel.rasp.library.python.common23.settings.utils import define_setting
from travel.rasp.morda.morda.views.direction import direction
from travel.rasp.morda.morda.views.logtail import logtail
from travel.rasp.morda.morda.views.mapping import map
from travel.rasp.morda.morda.views.mapping.objects import bounds as objects_bounds, info, objects
from travel.rasp.morda.morda.views.mapping.flights import bounds, flights
from travel.rasp.morda.morda.views.mapping.suggests.flights import suggests as flights_suggests
from travel.rasp.morda.morda.views.mapping.suggests.livemap import suggests as livemap_suggests
from travel.rasp.morda.morda.views.print_schedule import directions, print_schedule, stations
from travel.rasp.morda.morda.views.search.validate import validate
from travel.rasp.morda.morda.views.station import station
from travel.rasp.morda.morda.views.station_search import search as station_search
from travel.rasp.morda.morda.views.station.tablo import suggests
from travel.rasp.morda.morda.views.timecorrection import correction
from travel.rasp.morda.morda.views.thread import thread
from travel.rasp.morda.morda.views.thread_search import search_threads
from travel.rasp.morda.morda.views.version import version
from travel.rasp.morda.morda.views.tinyurl import restore_view, store_view

# Uncomment the next two lines to enable the admin:
# from django.contrib import admin
# admin.autodiscover()


from common.utils.errorhandlers import *


define_setting('INCLUDE_SEARCH_URL', default=False, converter=lambda x: bool(x))


urlpatterns = [
    url(r'^time/correction', correction),

    url(r'^version', version),

    url(r'^storeurl/(?P<path>.*)$', store_view),
    url(r'^-/(?P<token>.+)$', restore_view),

    url(r'^city/(?P<city_id>\d+)/direction$', direction, name="city_direction"),

    url(r'^search/validate/$', validate),

    url(r'^station/(?P<station_id>\d+)', station, name="station"),

    url(r'^thread/(?P<uid>[-\w*]+)', thread, name="thread"),

    url(r'^map/air/$', map, {'template_name': 'maps_air'}, name="airplanes"),
    url(r'^map/air/compact/$', map, {'template_name': 'maps_compact_air'}),
    url(r'^map/trains/$', map, {'template_name': 'maps_trains'}, name="trains"),
    url(r'^map/trains/compact/$', map, {'template_name': 'maps_compact_trains'}),

    url(r'^flights_in_air/bounds$', bounds),
    url(r'^flights_in_air/flights$', flights),

    url(r'^map/buses/$', map, {'template_name': 'maps_buses'}, name="buses"),

    url(r'^maps/(?P<type_>train|bus)/objects', objects),
    url(r'^maps/(?P<type_>train|bus)/info', info),
    url(r'^maps/(?P<type_>train|bus)/bounds', objects_bounds),

    url(r'^suggests/flights_in_air/(?P<field>number|company|airport|city)/$', flights_suggests),
    url(r'^suggests/livemap/(?P<table>train|livebus)/(?P<field>number|station|city)/$', livemap_suggests),

    url(r'^suggests/tablo/(?P<station_id>\d+)/$', suggests),

    url(r'^informers/', include('travel.rasp.morda.morda.informers.urls')),

    url(r'^widgets/ticket/$', RedirectView.as_view(url='/informers/widgets/ticket/', permanent=True)),
    url(r'^widgets/search/(?:(?P<type>vert|horiz)/)$', RedirectView.as_view(url='/informers/widgets/search/%(type)s', permanent=True)),

    url(r'^threads', search_threads, name="search_threads"),

    url(r'^station_search', station_search, name="station_search"),

    url(r'^print/helpers/directions', directions),
    url(r'^print/helpers/stations', stations),
    url(r'^print/schedule', print_schedule),

    url(r'^admin/maintenance/logtail/(?P<path>[\w\-./]+)$', logtail),

    url(r'^info/', include('travel.rasp.morda.staticpages.urls')),
    url(r'^buy/', include('travel.rasp.morda.morda.order.urls')),

    # Редиректы
    url(r'', include('travel.rasp.morda.morda.redirects.urls')),
] + handler_test_patterns
