# -*- coding: utf-8 -*-
""" Поставщик новостей разных станций """

import socket
import httplib
import urllib2
from datetime import date, timedelta
from xml.parsers.expat import ExpatError
from xml.etree import ElementTree as ET

from django.conf import settings

from common.utils.caching import cached
from common.utils.http import quick_urlopen


class NewsError(ValueError):
    pass


@cached(lambda: '/news/dmd')
def get_domodedovo_news():
    u""" Получение новостей Домодедово
         Выход: словарь данных """
    today = date.today()
    url = settings.NEWS_DOMODEDOVO_URL % (today - timedelta(days=30), today)
    try:
        info = quick_urlopen(url).read().strip()
        if info:
            tree = ET.fromstring(info)
            return [el.attrib for el in tree.getiterator('Item')[:settings.NEWS_COUNT]]

        else:
            raise NewsError(u"Не удалось получить данные Домодедово (%s): пустой результат" % url)

    except (httplib.HTTPException, urllib2.HTTPError, urllib2.URLError, socket.error), e:
        raise NewsError(u"Не удалось получить новости (%s): %s" % (url, e))

    except (ExpatError, AttributeError), e:
        raise NewsError(u"Ошибочный формат файла новостей (%s): %s" % (url, e))
