# -*- coding: utf-8 -*-

from lxml import etree

from django.conf import settings
from django.utils.http import urlencode

from common.utils.http import quick_urlopen


TRIES = 3


class Error(Exception):
    pass


class NotFound(Error):
    pass


class BadToken(Error):
    pass


class NoTriesLeft(Error):
    pass


STATUS_ERRORS = {
    'NOT_FOUND': NotFound,
    'BAD_TOKEN': BadToken
}


def _call_tinyurl(params):
    for _ in range(TRIES):
        response = quick_urlopen(settings.TINYURL + '?' + urlencode(params))

        tree = etree.parse(response)

        status = tree.xpath('//status')

        if status:
            status_text = status[0].text

            if status_text == 'TRY_AGAIN':
                continue

            raise STATUS_ERRORS.get(status_text, Error)(status_text)

        return tree

    raise NoTriesLeft


def store(url, userip=None):
    tree = _call_tinyurl({
        'method': 'store',
        'url': url,
        'from': 'ticket',
        'userip': userip
    })

    return tree.xpath('//token')[0].text


def retrieve(token, userip=None):
    tree = _call_tinyurl({
        'method': 'retrieve',
        'token': token,
        'from': 'ticket',
        'userip': userip
    })

    return tree.xpath('//url')[0].text
