# -*- coding: utf-8 -*-

from django.utils.translation import get_language

from common.utils.httpresponses import jsonp_response
from travel.rasp.morda.morda.models.mapping import DefaultSuggest
from travel.rasp.morda.morda.views.mapping.suggests.utils import Suggests, variants_to_response


@jsonp_response
def suggests(request, field):
    query = request.GET.get('part', '').lower()

    lang = get_language()

    return variants_to_response(get_flight_variants_iter(lang, field, query))


def get_flight_variants_iter(lang, field, query):
    lang = lang if lang in _flight_suggesters.keys() else 'ru'

    return _flight_suggesters[lang][field].variants_iter(query)


_flight_default_airport_sql = """
(
    SELECT DISTINCT s.title_{lang}
    FROM www_suggest s
    JOIN mapping_flight f ON f.station_from_id = s.object_id
    WHERE s.type='station'
)
UNION DISTINCT
(
    SELECT DISTINCT s.title_{lang}
    FROM www_suggest s
    JOIN mapping_flight f ON f.station_to_id = s.object_id
    WHERE s.type='station'
)
ORDER BY 1
"""


_flight_default_city_sql = """
(
    SELECT DISTINCT c.title_{lang}
    FROM www_suggest c
    JOIN www_station s ON s.settlement_id = c.object_id
    JOIN mapping_flight f ON f.station_from_id = s.id
    WHERE c.type='settlement'
)
UNION DISTINCT
(
    SELECT DISTINCT c.title_{lang}
    FROM www_suggest c
    JOIN www_station s ON s.settlement_id = c.object_id
    JOIN mapping_flight f ON f.station_to_id = s.id
    WHERE c.type='settlement'
)
ORDER BY 1
"""


_flight_number_suggest = Suggests("""SELECT DISTINCT number FROM mapping_flight ORDER BY 1""")
_flight_company_suggest = Suggests("""SELECT DISTINCT company_title FROM mapping_flight ORDER BY 1""")


_flight_suggesters = dict(
    (lang, {
        'number': _flight_number_suggest,
        'company': _flight_company_suggest,
        'airport': Suggests(_flight_default_airport_sql.format(lang=lang), DefaultSuggest.PLANE_STATION),
        'city': Suggests(_flight_default_city_sql.format(lang=lang), DefaultSuggest.PLANE_SETTLEMENT)
    }) for lang in ['ru', 'tr', 'uk']
)
