# -*- coding: utf-8 -*-

from django.utils.translation import get_language

from common.utils.httpresponses import jsonp_response
from travel.rasp.morda.morda.models.mapping import DefaultSuggest
from travel.rasp.morda.morda.views.mapping.suggests.utils import Suggests, variants_to_response


@jsonp_response
def suggests(request, table, field):
    query = request.GET.get('part', '').lower()

    lang = get_language()

    return variants_to_response(get_livemap_variants_iter(lang, table, field, query))


def get_livemap_variants_iter(lang, table, field, query):
    lang = lang if lang in _suggesters else 'ru'

    return _suggesters[lang][table][field].variants_iter(query)


def create_number_suggester(table):
    return Suggests(
        """
        SELECT DISTINCT r.number
        FROM www_route r
            JOIN www_rthread t ON r.id = t.route_id
            JOIN mapping_%s mt ON mt.thread_id = t.id
        ORDER BY 1
        """ % table
    )


def create_station_suggester(table, lang, default_suggest):
    return Suggests(
        """
        SELECT DISTINCT s.title_%s
        FROM
            (SELECT DISTINCT rts.station_id AS id
             FROM www_rtstation rts
             JOIN mapping_%s mt ON mt.thread_id = rts.thread_id
             WHERE rts.station_id IS NOT NULL
            ) AS f,
            www_suggest s
        WHERE s.object_id = f.id AND s.type='station'
        ORDER BY 1
        """ % (lang, table),
        default_suggest=default_suggest
    )


def create_city_suggester(table, lang, default_suggest):
    return Suggests(
        """
        SELECT DISTINCT s.title_%s
        FROM
            (SELECT DISTINCT s.settlement_id AS id
             FROM www_station s
             JOIN www_rtstation rts ON s.id = rts.station_id
             JOIN mapping_%s mt ON mt.thread_id = rts.thread_id
             WHERE s.settlement_id IS NOT NULL
            ) AS f,
            www_suggest s
        WHERE s.object_id = f.id AND s.type='settlement'
        ORDER BY 1
        """ % (lang, table),
        default_suggest=default_suggest
    )


def create_suggesters():
    suggesters = {}

    for table in ['train', 'livebus']:
        number_suggester = create_number_suggester(table)

        for lang in ['ru', 'tr', 'uk']:
            suggesters.setdefault(lang, {})[table] = {
                'number': number_suggester,
                'station': create_station_suggester(table, lang, DefaultSuggest.TRAIN_STATION),
                'city': create_city_suggester(table, lang, DefaultSuggest.TRAIN_SETTLEMENT)
            }

    suggesters['tr']['train']['number'] = Suggests(
        """
        SELECT DISTINCT r.number
        FROM www_route r
            JOIN www_rthread t ON r.id = t.route_id
            JOIN mapping_train mt ON mt.thread_id = t.id
        WHERE r.company_id = '5163'
        ORDER BY 1
        """
    )

    return suggesters


_suggesters = create_suggesters()

