# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.http import HttpResponsePermanentRedirect

from common.models.geo import Country
from common.utils.locations import composeurl
from common.xgettext.i18n import gettext, xgettext

from geosearch.views.station_search import get_cities

from travel.rasp.morda.morda.templates import choose_airport
from travel.rasp.morda.morda.templates.error import ErrorTemplate
from travel.rasp.morda.morda.views.teasers import TeaserSetMorda
from travel.rasp.morda.morda.utils.locations import get_search_url


def country_airports(request, search_form=None, search_type=None):
    """Страница выбора аэропортов страны"""

    if search_type:
        # До стран ищем общим поиском
        return HttpResponsePermanentRedirect(get_search_url(query=request.META['QUERY_STRING']))

    context = {
        'search_form': search_form,
        'teaser_page': ['search'],
        'teasers': TeaserSetMorda(request, 'other'),
        'title': gettext('Уточните пункты отправления и прибытия')
    }

    if isinstance(search_form.cleaned_data['from'].point, Country):
        context['airports_from'] = get_cities(search_form.cleaned_data['from'].point)

        if not context['airports_from']:
            message = xgettext(
                'Аэропорты в стране <country-title/> отсутствуют, или до них нет известных нам рейсов. '
                'Пожалуйста, выберите другой пункт отправления.',
                country_title=search_form.cleaned_data['from'].point.L_title
            )
            return ErrorTemplate.render(request, context, [message], title=message)

        context['airports_from_country'] = search_form.cleaned_data['from'].point

    if isinstance(search_form.cleaned_data['to'].point, Country):
        context['airports_to'] = get_cities(search_form.cleaned_data['to'].point)

        if not context['airports_to']:
            message = xgettext(
                'Аэропорты в стране <country-title/> отсутствуют, или до них нет известных нам рейсов. '
                'Пожалуйста, выберите другой пункт прибытия.',
                country_title=search_form.cleaned_data['to'].point.L_title
            )
            return ErrorTemplate.render(request, context, [message], title=message)

        context['airports_to_country'] = search_form.cleaned_data['to'].point

    return choose_airport.Template.render(request, context)
