# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import logging

from common.utils.banner_provider import get_banners, BannerError


log = logging.getLogger(__name__)


def search_banners(request, segments, yadirect=False):
    segs = []

    for seg in segments:
        if hasattr(seg, 'segments'):
            segs.extend(seg.segments)
        else:
            segs.append(seg)

    ttypes = set(r.t_type for r in segs)
    companies = set(r.company for r in segs if r.company)

    params = [
        ('transport-type', '\x0a'.join(t.code for t in ttypes)),
        ('transport-code', '\x0a'.join(c.iata.encode('cp1251') for c in companies if c.iata)),
    ]

    try:
        return get_banners(103, request, params, yadirect)
    except BannerError:
        log.exception('Ощибка получения баннеров')
        return {}
