# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.conf import settings


def calculate_counters(visible_segments):
    counters = {}
    t_types = {}

    for s in visible_segments:
        if hasattr(s, 't_type'):
            t_types[s.t_type.id] = t_types.get(s.t_type.id, 0) + 1

        elif hasattr(s, 'segments'):
            for r in s.segments:
                t_types[r.t_type.id] = t_types.get(r.t_type.id, 0) + 1

    if len(t_types.keys()) > 1:
        counters[70888] = True

        for t in t_types.keys():
            counters[settings.MORE_COUNTERS.get(t, 0)] = True

    if len(t_types.keys()) == 1:
        counters[settings.COUNTERS.get(t_types.keys()[0], 0)] = True

    return counters.keys()


