# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.schedule import StationSchedule


def add_schedule(segments):
    rtstations = [segment.rtstation_from for segment in segments if segment.rtstation_from]

    schedules = dict((s.rtstation_id, s)
                     for s in StationSchedule.objects.filter(rtstation__in=rtstations))

    for segment in segments:
        if segment.rtstation_from:
            thread_schedule = schedules.get(segment.rtstation_from.id)

            if thread_schedule:
                thread_schedule.thread = segment.thread

            segment.display_info['schedule'] = thread_schedule
