# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from django.conf import settings
from django.utils.http import urlencode

from common.utils import marketstat


search_log = marketstat.Log(settings.SEARCH_LOG)
rasp_users_search_log = marketstat.DsvLog(settings.RASP_USERS_SEARCH_LOG)


def search_params(get):
    """Параметры для перепоиска"""

    SEARCH_PARAMS = set(['fromName', 'fromId', 'toName', 'toId', 'when'])

    params = dict((name, value) for name, value in get.items() if name in SEARCH_PARAMS)

    return '?' + urlencode(params)

