# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from travel.rasp.morda.morda.views.teasers import TeaserSetMorda


def teaser_data(request, visible_segments, point_from, point_to, search_type, teaser_page=None):
    teaser_page = teaser_page and [teaser_page] or [search_type == 'suburban' and 'search_suburban' or 'search']

    # Плоские сегменты для тизеров
    segments = [s for s in visible_segments if not hasattr(s, 'segments')]

    for s in visible_segments:
        if hasattr(s, 'segments'):
            segments.extend(s.segments)

    t_types = set(hasattr(r, 'route') and r.route and r.route.t_type_id or getattr(r, 't_type_id', None) for r in segments)

    if 1 in t_types: teaser_page.append('search_trains')
    if 2 in t_types: teaser_page.append('search_planes')
    if 1 in t_types and not 2 in t_types: teaser_page.append('search_trains_only')
    if 2 in t_types and not 1 in t_types: teaser_page.append('search_planes_only')

    teaser_content = TeaserSetMorda(request, teaser_page, {
        'points': [point_from, point_to],
        'routes': segments
    })

    return {
        'teasers': teaser_content,
        'teaser_page': teaser_page,
    }

