# -*- coding: utf-8 -*-

from __future__ import absolute_import, unicode_literals

from django.utils.translation import get_language

from common.utils.date import human_date_without_year
from common.xgettext.i18n import xgettext, gettext, xformat


def search_title(point_from, point_to, t_type_code, when=None, next=False):
    kwargs = {
        'point_from_title': point_from.L_title,
        'point_to_title': point_to.L_title
    }

    if when:
        weekday_name = [
            gettext(u'в понедельник'),
            gettext(u'во вторник'),
            gettext(u'в среду'),
            gettext(u'в четверг'),
            gettext(u'в пятницу'),
            gettext(u'в субботу'),
            gettext(u'в воскресенье'),
        ][when.weekday()]

        kwargs['when'] = [human_date_without_year(when), ', ', weekday_name]
    else:
        kwargs['when'] = None

    if get_language() == 'ru':
        if t_type_code == 'train':
            if next:
                return xformat(u'Ближайшие поезда <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание поездов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            else:
                return xformat(u'Расписание поездов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'bus':
            if next:
                return xformat(u'Ближайшие автобусы <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание автобусов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            else:
                return xformat(u'Расписание автобусов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'suburban':
            if next:
                return xformat(u'Ближайшие электрички <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание электричек <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            return xformat(u'Расписание электричек <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'plane':
            if next:
                return xformat(u'Ближайшие самолёты <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание самолётов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            return xformat(u'Расписание самолётов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'sea':
            if next:
                return xformat(u'Ближайшие океанские лайнеры <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание океанских лайнеров <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            return xformat(u'Расписание океанских лайнеров <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'river':
            if next:
                return xformat(u'Ближайшие корабли <point-from-title case="phrase_form"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание кораблей <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            return xformat(u'Расписание кораблей <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        elif t_type_code == 'water':
            if next:
                return xformat(u'Ближайшие корабли <point-from-title case="phrase_form"/> <point-to-title case="phrase_to"/>', **kwargs)
            elif when:
                return xformat(u'Расписание кораблей <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
            return xformat(u'Расписание кораблей <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

        if next:
            return xformat(u'Ближайшие рейсы <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)
        elif when:
            return xformat(u'Расписание рейсов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>, <when/>', **kwargs)
        return xformat(u'Расписание рейсов <point-from-title case="phrase_from"/> <point-to-title case="phrase_to"/>', **kwargs)

    else:
        if t_type_code == 'train':
            if next:
                return xgettext(u'Ближайшие поезда: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание поездов: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            else:
                return xgettext(u'Расписание поездов: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'bus':
            if next:
                return xgettext(u'Ближайшие автобусы: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание автобусов: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            else:
                return xgettext(u'Расписание автобусов: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'suburban':
            if next:
                return xgettext(u'Ближайшие электрички: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание электричек: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            return xgettext(u'Расписание электричек: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'plane':
            if next:
                return xgettext(u'Ближайшие самолёты: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание самолётов: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            return xgettext(u'Расписание самолётов: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'sea':
            if next:
                return xgettext(u'Ближайшие океанские лайнеры: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание океанских лайнеров: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            return xgettext(u'Расписание океанских лайнеров: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'river':
            if next:
                return xgettext(u'Ближайшие корабли: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание кораблей: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            return xgettext(u'Расписание кораблей: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        elif t_type_code == 'water':
            if next:
                return xgettext(u'Ближайшие корабли: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
            elif when:
                return xgettext(u'Расписание кораблей: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
            return xgettext(u'Расписание кораблей: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)

        if next:
            return xgettext(u'Ближайшие рейсы: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
        elif when:
            return xgettext(u'Расписание рейсов: <point-from-title/>&nbsp;&mdash; <point-to-title/>, <when/>', **kwargs)
        return xgettext(u'Расписание рейсов: <point-from-title/>&nbsp;&mdash; <point-to-title/>', **kwargs)
