# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from datetime import timedelta

from common.models.geo import Station
from common.utils.date import human_date
from common.utils.locations import change_params
from common.xgettext.i18n import gettext

from travel.rasp.morda.morda.utils.locations import suburban_search_url

VNUKOVO = ('Внуково', 's9600215')
DOMODEDOVO = ('Домодедово', 's9600216')
SHEREMETYEVO = ('Шереметьево', 's9881841')

AEROEXPRESSES = {
    2000007: VNUKOVO,
    2000005: DOMODEDOVO,
    9868808: DOMODEDOVO,
    2000006: SHEREMETYEVO,
    9601830: SHEREMETYEVO,
    9600721: SHEREMETYEVO,
    9601338: SHEREMETYEVO,
    9602218: SHEREMETYEVO,
    9602258: SHEREMETYEVO,
    9600941: SHEREMETYEVO,
    9600911: SHEREMETYEVO,
    9601728: SHEREMETYEVO,
    9600821: SHEREMETYEVO,
    9601349: SHEREMETYEVO,
    9601666: SHEREMETYEVO
}


def get_type_url(request, type_, station):
    if type_ == 'aeroex':
        if request.GET.get('span') == 'day':
            when = human_date(request.now.date())
        elif request.GET.get('span') == 'tomorrow':
            when = human_date(request.now.date() + timedelta(1))
        else:
            when = gettext(u'на все дни')

        if station.t_type_id == 2:
            return suburban_search_url(station.settlement, station, when=when,
                                       aeroex='y')

        airport = AEROEXPRESSES.get(station.pk)

        if airport:
            return suburban_search_url(station, airport, when=when,
                                       aeroex='y')

        airports = list(Station.objects.filter(settlement=station.settlement, t_type=2, hidden=False))

        if len(airports) == 1:
            airport = airports[0]
            return suburban_search_url(station.settlement, airport, when=when,
                                       aeroex='y')

    return change_params(request.GET, {'type': type_})
