# -*- coding: utf-8 -*-

from common.models.geo import ExternalDirection, Settlement, Country
from common.utils.locations import composeurl
from common.utils.text import cut_direction
from travel.rasp.morda.morda.templates.station.suburban import Template as SuburbanTemplate
from travel.rasp.morda.morda.views.station.utils import smart_sort, fill_spans_context, get_schedule_date_by_span
from travel.rasp.morda.morda.views.teasers import TeaserSetMorda
from stationschedule import get_schedule_class


def suburban(request, context, station, city, type_, today):
    # Направления
    requested_direction = request.GET.get('subdir') or request.GET.get('direction')

    schedule_cls = get_schedule_class(station, schedule_type='suburban', t_type_code='suburban')
    schedule = schedule_cls(station, requested_direction=requested_direction, city=city)

    directions = schedule.direction_code_title_count_list
    internal_direction = schedule.internal_direction
    direction_code = schedule.direction_code
    direction_title = schedule.direction_title

    if directions:
        context['direction_code'] = direction_code

        if direction_code != schedule.DIRECTION_ALL:
            if internal_direction:
                try:
                    direction_title = u'<a href="%s">%s</a>' % (
                        composeurl('city_direction', internal_direction.suburban_zone.settlement_id,
                                   params={'direction': direction_code}),
                        cut_direction(internal_direction.full_title)
                        )
                except AttributeError:
                    pass

            context['direction_title'] = direction_title or direction_title

        # Группировка направлений (RASP-2298)
        columns = (len(directions) - 1) / 4 + 1
        context['directions'] = [directions[i:i + columns] for i in range(0, len(directions), columns)]

        # RASP-11202
        context['fast_search_points'] = {
            d.base_station
            for d in ExternalDirection.objects.filter(externaldirectionmarker__station=station)
            if d.base_station.id != station.id
        }

    current_plan, next_plan = schedule.current_next_plans(today)

    current_span = fill_spans_context(request, station, context, current_plan=current_plan,
                                      next_plan=next_plan, direction=direction_code)

    local_date = get_schedule_date_by_span(request, station, current_span)
    if local_date:
        context['date'] = local_date

    schedule.build(schedule_date=local_date, schedule_plan=current_span.schedule_plan)

    context['schedule'] = schedule.schedule_routes

    smart_sort(context)

    # RASP-2329
    context['form'] = 'suburban'

    is_russian_station = not station.country or station.country.id == Country.RUSSIA_ID
    if station.get_tz_name() == 'Europe/Moscow' and is_russian_station:
        context['time_zone'] = context['local_tz'] = Settlement.get_default_city()
        context['tz_cities'] = []

    context['teasers'] = TeaserSetMorda(request, 'tablo', (context['station'], context['schedule']))

    return SuburbanTemplate.render(request, context)
