# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.transport import TransportType
from common.xgettext.i18n import gettext, xgettext


def construct_titles(today, station, page_type, event=None, terminal=None, show_event=True):
    get_station_title = station.L_popular_title_extra
    get_settlement_title = station.settlement and station.settlement.L_title or (lambda: '')

    station_title = get_station_title()
    settlement_title = get_settlement_title()

    title_kwargs = {
        'station_title': get_station_title,
        'settlement_title': get_settlement_title
    }
    page_title_kwargs = {
        'station_title': get_station_title,
        'settlement_title': get_settlement_title
    }

    if page_type == 'tablo':
        if station.t_type.code == 'plane':
            title_kwargs['station_title'] = station.L_popular_title_extra(terminal=terminal)

            if station.is_foreign():
                if station_title != settlement_title and settlement_title:
                    # Пример фразы: Расписание аэропорта Ватри (Париж). Пример страницы: http://rasp.yandex.ru/info/station/9630172
                    title_form = xgettext('Расписание аэропорта <station-title/> (<settlement-title/>)',
                                          **title_kwargs)
                    # Пример фразы: Расписание аэропорта Ватри (Париж). Пример страницы: http://rasp.yandex.ru/info/station/9630172
                    page_title_form = xgettext('Расписание аэропорта <station-title/> (<settlement-title/>)',
                                               **page_title_kwargs)

                else:
                    # Пример фразы: Расписание аэропорта Ватри. Пример страницы: http://rasp.yandex.ru/info/station/9630172
                    title_form = xgettext('Расписание аэропорта <station-title/>', **title_kwargs)
                    # Пример фразы: Расписание аэропорта Ватри. Пример страницы: http://rasp.yandex.ru/info/station/9630172
                    page_title_form = xgettext('Расписание аэропорта <station-title/>', **page_title_kwargs)
            else:
                if station_title != settlement_title and settlement_title:
                    # Пример фразы: Табло аэропорта Внуково (Москва). Пример страницы: http://rasp.yandex.ru/station/9600215
                    title_form = xgettext('Табло аэропорта <station-title/> (<settlement-title/>)', **title_kwargs)
                    # Пример фразы: Табло аэропорта Внуково (Москва). Пример страницы: http://rasp.yandex.ru/station/9600215
                    page_title_form = xgettext('Табло аэропорта <station-title/> (<settlement-title/>)',
                                               **page_title_kwargs)

                else:
                    # Пример фразы: Табло аэропорта Внуково. Пример страницы: http://rasp.yandex.ru/station/9600215
                    title_form = xgettext('Табло аэропорта <station-title/>', **title_kwargs)
                    # Пример фразы: Табло аэропорта Внуково. Пример страницы: http://rasp.yandex.ru/station/9600215
                    page_title_form = xgettext('Табло аэропорта <station-title/>', **page_title_kwargs)

            if terminal:
                page_title_form = [page_title_form,
                                   xgettext(', терминал <terminal/>', terminal=terminal.name)]
        else:
            # Пример фразы: Белорусский вокзал: табло вокзала. Пример страницы: http://rasp.yandex.ru/station/2000006
            title_form = xgettext('<station-title/>: табло вокзала', **title_kwargs)
            # Пример фразы: Табло вокзала Белорусский вокзал. Пример страницы: http://rasp.yandex.ru/station/2000006
            page_title_form = xgettext('Табло вокзала <station-title/>', **page_title_kwargs)

        title_kwargs['station_title'] = get_station_title

        if show_event:
            event_name = {'departure': gettext('Отправление'), 'arrival': gettext('Прибытие')}.get(event, gettext(
                'Отправление'))

            title_form = [title_form, '. ', event_name, '.']
            page_title_form = [page_title_form, '. ', event_name, '.']

    else:
        t_type = page_type
        if t_type == 'schedule':
            t_type = station.t_type.code

        # RASP-9053
        if t_type == 'bus' and station.is_mta:
            if station_title != settlement_title and settlement_title:
                # Пример фразы: Екатеринбург (Южный автовокзал): расписание автобусов
                page_title_form = xgettext('<settlement-title/> (<station-title/>): расписание автобусов',
                                           **page_title_kwargs)
            else:
                # Пример фразы: Южный автовокзал: расписание автобусов
                page_title_form = xgettext('<station-title/>: расписание автобусов', **page_title_kwargs)

            year = ('%s год' % today.year) if (1 <= today.month <= 10) else (
                '%s-%s гг' % (today.year, today.year + 1))
            title_form = [page_title_form, ', %s' % year]

        elif t_type in TransportType.WATER_TTYPE_CODES:
            if station_title != settlement_title and settlement_title:
                # Пример фразы: Москва (Лыткарино): расписание теплоходов
                page_title_form = xgettext('<settlement-title/> (<station-title/>): расписание теплоходов',
                                           **page_title_kwargs)
            else:
                # Пример фразы: Лыткарино: расписание теплоходов
                page_title_form = xgettext('<station-title/>: расписание теплоходов', **page_title_kwargs)

            title_form = page_title_form

        else:
            title_kwargs['station_type_name'] = station.station_type.L_name(case='dative')
            title_kwargs['nbsp'] = '&nbsp;'

            station_type_id = station.station_type_id

            station_popular_title = station.L_popular_title(fallback=False)

            if station_popular_title and station.settlement:
                title_kwargs['station_title'] = (station_title != station.settlement.L_title()) and (
                    ' (%s)' % station_title) or ''

            if t_type == 'train':
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание поездов: Москва (Белорусский вокзал)
                        title_form = xgettext('Расписание поездов: <settlement-title/><station-title/>',
                                              **title_kwargs)
                    else:
                        # Пример фразы: Расписание поездов: Белорусский вокзал
                        title_form = xgettext('Расписание поездов: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание поездов в&nbsp;аэропорту <station-title/>', **title_kwargs)
                    else:
                        if station_type_id == 2:
                            title_form = xgettext('Расписание поездов по&nbsp;платформе <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 3:
                            title_form = xgettext('Расписание поездов по&nbsp;остановочному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 4:
                            title_form = xgettext('Расписание поездов по&nbsp;блок-посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 5:
                            title_form = xgettext('Расписание поездов по&nbsp;посту <station-title/>', **title_kwargs)
                        elif station_type_id == 6:
                            title_form = xgettext('Расписание поездов по&nbsp;разъезду <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 7:
                            title_form = xgettext('Расписание поездов по&nbsp;обгонному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 8:
                            title_form = xgettext('Расписание поездов по&nbsp;вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 9:
                            title_form = xgettext('Расписание поездов по&nbsp;аэропорту <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание поездов по&nbsp;станции <station-title/>',
                                                  **title_kwargs)
            elif t_type == 'plane':
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание самолетов: Москва (Внуково)
                        title_form = xgettext('Расписание самолётов: <settlement-title/><station-title/>',
                                              **title_kwargs)
                    else:
                        # Пример фразы: Расписание самолетов: Внуково
                        title_form = xgettext('Расписание самолётов: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание самолётов в&nbsp;аэропорту <station-title/>',
                                              **title_kwargs)
                    else:
                        if station_type_id == 9:
                            title_form = xgettext('Расписание самолётов по&nbsp;аэропорту <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание самолётов по&nbsp;станции <station-title/>',
                                                  **title_kwargs)
            elif t_type == 'suburban':
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание электричек: Москва (Белорусский вокзал)
                        title_form = xgettext('Расписание электричек: <settlement-title/><station-title/>',
                                              **title_kwargs)
                    else:
                        # Пример фразы: Расписание электричек: Белорусский вокзал
                        title_form = xgettext('Расписание электричек: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание электричек в&nbsp;аэропорту <station-title/>',
                                              **title_kwargs)
                    else:
                        if station_type_id == 2:
                            title_form = xgettext('Расписание электричек по&nbsp;платформе <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 3:
                            title_form = xgettext(
                                'Расписание электричек по&nbsp;остановочному пункту <station-title/>', **title_kwargs)
                        elif station_type_id == 4:
                            title_form = xgettext('Расписание электричек по&nbsp;блок-посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 5:
                            title_form = xgettext('Расписание электричек по&nbsp;посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 6:
                            title_form = xgettext('Расписание электричек по&nbsp;разъезду <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 7:
                            title_form = xgettext('Расписание электричек по&nbsp;обгонному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 8:
                            title_form = xgettext('Расписание электричек по&nbsp;вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 9:
                            title_form = xgettext('Расписание электричек по&nbsp;аэропорту <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание электричек по&nbsp;станции <station-title/>',
                                                  **title_kwargs)
            elif t_type == 'aeroex':
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание аэроэкспрессов: Москва (Внуково)
                        title_form = xgettext('Расписание аэроэкспрессов: <settlement-title/><station-title/>',
                                              **title_kwargs)
                    else:
                        # Пример фразы: Расписание аэроэкспрессов: Внуково
                        title_form = xgettext('Расписание аэроэкспрессов: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание аэроэкспрессов в&nbsp;аэропорту <station-title/>',
                                              **title_kwargs)
                    else:
                        if station_type_id == 2:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;платформе <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 3:
                            title_form = xgettext(
                                'Расписание аэроэкспрессов по&nbsp;остановочному пункту <station-title/>',
                                **title_kwargs)
                        elif station_type_id == 4:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;блок-посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 5:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 6:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;разъезду <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 7:
                            title_form = xgettext(
                                'Расписание аэроэкспрессов по&nbsp;обгонному пункту <station-title/>', **title_kwargs)
                        elif station_type_id == 8:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 9:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;аэропорту <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание аэроэкспрессов по&nbsp;станции <station-title/>',
                                                  **title_kwargs)
            elif t_type == 'bus':
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание автобусов: Москва (Автовокзал Щелковский)
                        title_form = xgettext('Расписание автобусов: <settlement-title/><station-title/>',
                                              **title_kwargs)
                    else:
                        # Пример фразы: Расписание автобусов: Автовокзал Щелковский
                        title_form = xgettext('Расписание автобусов: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание автобусов в&nbsp;аэропорту <station-title/>',
                                              **title_kwargs)
                    else:
                        if station_type_id == 2:
                            title_form = xgettext('Расписание автобусов по&nbsp;платформе <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 3:
                            title_form = xgettext(
                                'Расписание автобусов по&nbsp;остановочному пункту <station-title/>', **title_kwargs)
                        elif station_type_id == 4:
                            title_form = xgettext('Расписание автобусов по&nbsp;блок-посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 5:
                            title_form = xgettext('Расписание автобусов по&nbsp;посту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 6:
                            title_form = xgettext('Расписание автобусов по&nbsp;разъезду <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 7:
                            title_form = xgettext('Расписание автобусов по&nbsp;обгонному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 8:
                            title_form = xgettext('Расписание автобусов по&nbsp;вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 9:
                            title_form = xgettext('Расписание автобусов по&nbsp;аэропорту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 10:
                            title_form = xgettext('Расписание автобусов по&nbsp;автовокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 11:
                            title_form = xgettext(
                                'Расписание автобусов по&nbsp;автобусной остановке <station-title/>', **title_kwargs)
                        elif station_type_id == 13:
                            title_form = xgettext('Расписание автобусов по&nbsp;порту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 14:
                            title_form = xgettext('Расписание автобусов по&nbsp;портпункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 15:
                            title_form = xgettext('Расписание автобусов по&nbsp;пристани <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 16:
                            title_form = xgettext('Расписание автобусов по&nbsp;речному вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 17:
                            title_form = xgettext('Расписание автобусов по&nbsp;морскому вокзалу <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание автобусов по&nbsp;станции <station-title/>',
                                                  **title_kwargs)
            else:
                if station_popular_title:
                    if station.settlement:
                        # Пример фразы: Расписание: Москва (Автовокзал Щелковский)
                        title_form = xgettext('Расписание: <settlement-title/><station-title/>', **title_kwargs)
                    else:
                        # Пример фразы: Расписание: Автовокзал Щелковский
                        title_form = xgettext('Расписание: <station-title/>', **title_kwargs)
                else:
                # Без народного названия:
                    if station.t_type.code == 'plane':
                        title_form = xgettext('Расписание в&nbsp;аэропорту <station-title/>', **title_kwargs)
                    else:
                        if station_type_id == 2:
                            title_form = xgettext('Расписание по&nbsp;платформе <station-title/>', **title_kwargs)
                        elif station_type_id == 3:
                            title_form = xgettext('Расписание по&nbsp;остановочному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 4:
                            title_form = xgettext('Расписание по&nbsp;блок-посту <station-title/>', **title_kwargs)
                        elif station_type_id == 5:
                            title_form = xgettext('Расписание по&nbsp;посту <station-title/>', **title_kwargs)
                        elif station_type_id == 6:
                            title_form = xgettext('Расписание по&nbsp;разъезду <station-title/>', **title_kwargs)
                        elif station_type_id == 7:
                            title_form = xgettext('Расписание по&nbsp;обгонному пункту <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 8:
                            title_form = xgettext('Расписание по&nbsp;вокзалу <station-title/>', **title_kwargs)
                        elif station_type_id == 9:
                            title_form = xgettext('Расписание по&nbsp;аэропорту <station-title/>', **title_kwargs)
                        elif station_type_id == 10:
                            title_form = xgettext('Расписание по&nbsp;автовокзалу <station-title/>', **title_kwargs)
                        elif station_type_id == 11:
                            title_form = xgettext('Расписание по&nbsp;автобусной остановке <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 13:
                            title_form = xgettext('Расписание по&nbsp;порту <station-title/>', **title_kwargs)
                        elif station_type_id == 14:
                            title_form = xgettext('Расписание по&nbsp;портпункту <station-title/>', **title_kwargs)
                        elif station_type_id == 15:
                            title_form = xgettext('Расписание по&nbsp;пристани <station-title/>', **title_kwargs)
                        elif station_type_id == 16:
                            title_form = xgettext('Расписание по&nbsp;речному вокзалу <station-title/>',
                                                  **title_kwargs)
                        elif station_type_id == 17:
                            title_form = xgettext('Расписание по&nbsp;морскому вокзалу <station-title/>',
                                                  **title_kwargs)
                        else:
                            title_form = xgettext('Расписание по&nbsp;станции <station-title/>', **title_kwargs)

            if show_event and page_type != 'suburban':
                event_name = {
                    'departure': gettext('Отправление'),
                    'arrival': gettext('Прибытие')
                }.get(event, gettext('Отправление'))

                title_form = [title_form, '. ', event_name]

            page_title_form = title_form

            if 1 <= today.month <= 10:
                year = xgettext('<year/> г', year=unicode(today.year))
            else:
                year = xgettext('<year_prev/>-<year_next/> гг',
                                year_prev=unicode(today.year), year_next=unicode(today.year + 1))

            title_form = [title_form,
                          xgettext('. График <year/>, с учетом оперативных изменений.',year=year)]

    return {
        'title': title_form,
        'page_title': page_title_form,
    }
