# -*- coding: utf-8 -*-

from urlparse import urlparse

from django.conf import settings
from django.http import HttpResponse, HttpResponsePermanentRedirect, Http404

from travel.rasp.morda.morda.utils import tinyurl


def store_view(request, path):
    host = request.META['HTTP_HOST']

    url = 'https://%s/%s' % (host, path)

    query_string = request.META['QUERY_STRING']
    if query_string:
        url += '?' + query_string

    token = tinyurl.store(url, userip=request.META.get('REMOTE_ADDR', ''))

    return HttpResponse(
        "https://%s/-/%s" % (host, token), content_type='text/plain')


def restore_view(request, token):
    url = restore(request, token)

    return HttpResponsePermanentRedirect(url)


def restore(request, token):
    host = request.META['HTTP_HOST']

    try:
        url = tinyurl.retrieve(
            token, userip=request.META.get('REMOTE_ADDR', ''))
    except tinyurl.NotFound:
        raise Http404
    except tinyurl.BadToken:
        pass
    else:
        o = urlparse(url)

        if o.hostname == host or o.hostname in settings.SUPPORTED_HOSTS:
            return url

    return "https://%s/" % host
