#!/usr/bin/env python2
# coding: utf8
from nginx_log_normalize_functions import nginx_log_normalize_uri


# Если в регулярке есть исключающие символы, заводим как кортеж, иначе просто как строку
paths = [
    # Дашборд settlement-station
    (r'settlement/(\d+)/stations', 'settlement/{id}/stations'),
    (r'settlement/([\w-]+)/stations', 'settlement/{slug}/stations'),
    (r'settlement/(\d+)/directions', 'settlement/{id}/directions'),
    (r'settlement/(\d+)/teasers', 'settlement/{id}/teasers'),
    (r'settlement/(\d+)/search-sample-points', 'settlement/{id}/search-sample-points'),
    (r'settlement/(\d+)/popular-directions', 'settlement/{id}/popular-directions'),
    (r'settlement/(\d+)/train-popular-directions', 'settlement/{id}/train-popular-directions'),
    (r'settlement/([\w-]+)/transport-popular-directions', 'settlement/{slug}/transport-popular-directions'),
    r'settlement/',

    r'station/popular_directions',
    r'station/city_stations',
    r'station/quick',
    r'station/stops',
    r'station/',

    # Дашборд search-tariffs
    r'search/next',
    r'search/parse-context',
    r'search/search',
    r'search/train-segment',
    r'search/transfers',
    r'search/canonicals',

    r'segments/tariffs',
    r'segments/min-tariffs',
    r'segments/tariffs/poll',
    r'segments/bus-tariffs',

    r'tariffs/static-tariffs',
    r'tariffs/min-static-tariffs',
    r'tariffs/suburban',
    r'tariffs/plane/poll',
    r'tariffs/plane/',

    # Дашборд other
    r'thread/map',
    r'thread/',

    r'transport',

    r'articles',
    r'currencies',
    r'countries',

    r'statictext/disclaimers',
    r'altlinks',
    r'version',
]


def nginx_log_normalize_path(uri):
    return nginx_log_normalize_uri(paths, uri, '.*/')
