import logging
import os
from functools import partial

from travel.library.python.tracing.django import Tracing
from travel.library.python.tracing.gunicorn import build_post_fork
from travel.library.python.dev.pydevd_inject import register_signals_for_debugger
from travel.rasp.library.python.tracing.sampling import build_jaeger_config

from travel.rasp.library.python.common23.server.gunicorn.default import *  # noqa
from travel.rasp.library.python.common23.server.gunicorn import default


bind = 'unix:/tmp/yandex-rasp-morda-backend-gunicorn.sock'
max_requests = int(os.getenv('GUNICORN_MAX_REQUESTS', 10000))
workers = int(os.getenv('GUNICORN_WORKERS', 20))

from travel.rasp.library.python.common23.logging import log_run_time  # noqa
log = logging.getLogger(__name__)
log_run_time = partial(log_run_time, logger=log, log_level=logging.DEBUG)


post_fork = build_post_fork(build_jaeger_config('rasp.morda_backend'), wrapper_cls=Tracing)


def on_starting(server):
    default.on_starting(server)
    with log_run_time('Geometry loading'):
        _load_geometry()


def on_reload(server):
    default.on_reload(server)
    with log_run_time('Geometry reloading'):
        _load_geometry()


def post_worker_init(worker):
    register_signals_for_debugger()


def _load_geometry():
    from mapping.drawers import TrainPathDrawer, LimePathDrawer
    TrainPathDrawer.storage.preload()
    LimePathDrawer.storage.preload()
