# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import os

from django.apps import AppConfig
from django.conf import settings

from travel.rasp.library.python.common23.logging.mongo.mongo_handler import MongoHandler


class MordaBackendAppConfig(AppConfig):
    name = 'travel.rasp.morda_backend.morda_backend'
    label = 'morda_backend'

    def ready(self):
        # в случае если мы собираемся - нам не нужно инициализировать процессы, celery и тд,
        # так как в некоторых случаях потребуются соединение до mongo
        if os.environ.get('RASP_IS_BUILDING'):
            return

        MongoHandler.ensure_indexes_from_config(settings.LOGGING)
