# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.models.staticpages import ArticleBinding, StaticPage


log = logging.getLogger(__name__)


def get_articles(settlement, transport_type, country, limit):
    """
    https://st.yandex-team.ru/RASPFRONT-6605
    """
    common_qs = ArticleBinding.objects.filter(
        country=country, t_type=transport_type
    ).select_related('page').defer(
        # content fields are large
        'page__content', 'page__content_en', 'page__content_ru', 'page__content_tr', 'page__content_uk'
    ).order_by('priority')

    articles = []
    if settlement:
        settlement_bindings = common_qs.filter(settlement=settlement)[:limit]
        articles = [b.page for b in settlement_bindings]

    if len(articles) < limit:
        transport_bindings = common_qs.filter(settlement__isnull=True)[:(limit - len(articles))]
        articles += [b.page for b in transport_bindings]

    return articles


def get_staticpage(slug, country):
    kwargs = {'national_version': country.code, 'is_published': 1}
    # it's like old morda behavior: /info/<id> - is valid urls for static pages
    if slug.isnumeric():
        kwargs['id'] = slug
    else:
        kwargs['slug'] = slug

    try:
        return StaticPage.objects.get(**kwargs)
    except StaticPage.DoesNotExist:
        return None
