# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.article.data_layer import get_articles, get_staticpage
from travel.rasp.morda_backend.morda_backend.article.serialization import (
    ArticlesResponseSchema, ArticlesQuerySchema, StaticPageQuerySchema, StaticPageSchema
)
from travel.rasp.morda_backend.morda_backend.settlement.data_layer.settlement import (
    get_visible_settlement_by_id, get_visible_settlement_by_slug
)

log = logging.getLogger(__name__)


@api_view(['GET'])
def articles(request):
    """
    Список статических страниц - статей (выборка по привязкам)
    /ru/articles/?country=RU&t_type=train&settlement_slug=yekaterinburg&limit=3
    """
    context, errors = ArticlesQuerySchema().load(request.GET)
    if errors:
        return Response(
            {'result': {}, 'errors': errors},
            status=status.HTTP_400_BAD_REQUEST
        )

    settlement = None
    if context.settlement_id:
        settlement = get_visible_settlement_by_id(context.settlement_id)
    elif context.settlement_slug:
        settlement = get_visible_settlement_by_slug(context.settlement_slug)

    data = get_articles(settlement, context.transport_type, context.country, context.limit)

    result, errors = ArticlesResponseSchema().dump({
        'articles': data,
    })

    return Response({
        'result': result,
        'errors': errors
    }, status=status.HTTP_200_OK)


@api_view(['GET'])
def staticpage(request):
    """
    Информация о статической странице
    /ru/staticpage/?slug=covid-19
    """
    context, errors = StaticPageQuerySchema().load(request.GET)
    if errors:
        return Response(
            {'result': {}, 'errors': errors},
            status=status.HTTP_400_BAD_REQUEST
        )

    page = get_staticpage(context.slug, context.country)

    if not page:
        return Response(
            {'result': {}, 'errors': 'Page does not exists'},
            status=status.HTTP_404_NOT_FOUND
        )

    result, errors = StaticPageSchema().dump(page)

    return Response({
        'result': result,
        'errors': errors
    }, status=status.HTTP_200_OK)
