# -*- coding: utf-8 -*-

import json
from functools import wraps

from django.http import HttpResponse


def json_response(func):
    @wraps(func)
    def wrapper(request, *args, **kwargs):
        data = func(request, *args, **kwargs)

        serialized = json.dumps(
            data,
            default=None,
            ensure_ascii=False,
            separators=(',', ':')
        )

        return HttpResponse(serialized, content_type="application/json; charset=utf-8")

    return wrapper
