# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from raven.contrib.django.models import client
from rest_framework import status
from rest_framework.response import Response
from rest_framework.views import exception_handler


log = logging.getLogger(__name__)


def rest_framework_exception_handler(exc, context):
    response = exception_handler(exc, context)
    if response is not None:
        return response

    client.captureException()
    log.exception('Ошибка обработки запроса:\n%r\n', context)

    return Response({
        'errors': {
            'internal_error': {'type': 'internal_error',
                               'message': exc.message,
                               'data': {}},
        }
    }, status=status.HTTP_500_INTERNAL_SERVER_ERROR)
