# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType
from common.models.schedule import TrainPurchaseNumber


def fetch_and_filter_train_purchase_numbers(segments):
    """RASPFRONT-5653, RASPFRONT-8825 Получение и фильтр поездов, дублирующих электрички-экспрессы"""
    threads = []

    for segment in segments:
        if (
            segment.t_type.id == TransportType.SUBURBAN_ID
            and segment.thread.t_subtype and segment.thread.t_subtype.has_train_tariffs
        ):
            threads.append(segment.thread)

    result = TrainPurchaseNumber.get_train_purchase_numbers(threads)
    train_purchase_numbers = frozenset(v for row in result.values() for v in row)
    filtered = []

    for segment in segments:
        if segment.t_type.id == TransportType.TRAIN_ID and segment.number in train_purchase_numbers:
            continue
        if segment.thread.id in result:
            segment.train_purchase_numbers = result[segment.thread.id]

        filtered.append(segment)

    return filtered
