# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema
from marshmallow import fields, post_load

from common.utils.namedtuple import namedtuple_with_defaults
from travel.rasp.morda_backend.morda_backend.serialization.schema_bases import PointsShowHiddenQuerySchema


CanonicalsContext = namedtuple_with_defaults('CanonicalContext', ['point_from', 'point_to', 'transport_type'])


class CanonicalSchema(Schema):
    point_from = fields.String(attribute='point_from.slug', dump_to="pointFrom")
    point_to = fields.String(attribute='point_to.slug', dump_to="pointTo")
    transport_type = fields.String(dump_to='transportType')


class CanonicalPointSchema(Schema):
    title = fields.Function(lambda obj: obj.L_title())


class CanonicalsElementSchema(Schema):
    canonical = fields.Nested(CanonicalSchema)
    point_from = fields.Nested(CanonicalPointSchema, dump_to="pointFrom")
    point_to = fields.Nested(CanonicalPointSchema, dump_to="pointTo")


class CanonicalsQuerySchema(PointsShowHiddenQuerySchema):
    transport_type = fields.String(load_from='transportType', dump_to='transportType')

    @post_load
    def make_context(self, data):
        return CanonicalsContext(**data)


class CanonicalsResponseSchema(Schema):
    canonicals = fields.Nested(CanonicalsElementSchema, many=True)
