# coding: utf-8
from common.models.geo import Country, Region, Settlement, Station


def get_point_timezone(point):
    return point.get_tz_name() if hasattr(point, 'get_tz_name') else None


def get_point_country(point):
    return point if isinstance(point, Country) else point.country


def get_point_region(point):
    return None if isinstance(point, Country) else point if isinstance(point, Region) else point.region


def get_point_settlement(point):
    return point.settlement if isinstance(point, Station) else point if isinstance(point, Settlement) else None
