# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.utils.translation import get_language
from marshmallow import Schema, fields, post_load
from marshmallow.exceptions import ValidationError

from travel.rasp.morda_backend.morda_backend.search.parse_context.geosearch_wrapper import (
    InputSearchContext, TransportTypeNotFoundError, ClientSettlementNotFoundError)


class InputSearchContextSchema(Schema):
    from_slug = fields.String()
    from_key = fields.String()
    from_title = fields.String()
    to_slug = fields.String()
    to_key = fields.String()
    to_title = fields.String()
    t_type = fields.String()
    client_settlement_id = fields.String()
    national_version = fields.String(required=True)
    nearest = fields.Boolean()

    @post_load
    def make_context(self, data):
        try:
            return InputSearchContext(
                from_key=data.get('from_key'),
                from_title=data.get('from_title'),
                to_key=data.get('to_key'),
                to_title=data.get('to_title'),
                t_type_code=data.get('t_type'),
                client_settlement_id=data.get('client_settlement_id'),
                national_version=data['national_version'],
                language=get_language(),
                nearest=data.get('nearest'),
                from_slug=data.get('from_slug'),
                to_slug=data.get('to_slug'))
        except TransportTypeNotFoundError:
            raise ValidationError('t_type_not_found', field_names=['t_type'])
        except ClientSettlementNotFoundError:
            raise ValidationError('settlement_not_found', field_names=['client_settlement_id'])
