# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.models.schedule import RThread
from route_search.transfers.transfers import get_transfer_variants


log = logging.getLogger(__name__)


def get_full_path(path, station_from_id, station_to_id):
    station_from_index = None
    for i, station_id in enumerate(path):
        if station_id == station_from_id:
            station_from_index = i
        elif station_id == station_to_id:
            if station_from_index is not None:
                return path[station_from_index:i+1]


def _fill_thread_stations(variants):
    for variant in variants:
        for segment in variant.segments:
            if isinstance(segment.thread, RThread):
                path = [x.station_id for x in segment.thread.path]
                full_path = get_full_path(path, segment.station_from.id, segment.station_to.id)
                if full_path:
                    segment.full_path = full_path


def get_pm_variants(point_from, point_to, when, transport_types=None):
    if transport_types:
        transport_types = [t.code for t in transport_types]
    variants = list(get_transfer_variants(point_from, point_to, when, transport_types, filter_single_variants=False))
    _fill_thread_stations(variants)

    return variants
