# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from django.http import JsonResponse

from travel.rasp.morda_backend.morda_backend.search.transfers.serialization import TransfersVariantsQuerySchema
from travel.rasp.morda_backend.morda_backend.search.pm_variants.serialization import PMVariantsResponseSchema
from travel.rasp.morda_backend.morda_backend.search.pm_variants.service import get_pm_variants


log = logging.getLogger(__name__)


def pathfinder_maps_variants(request):
    query, errors = TransfersVariantsQuerySchema().load(request.GET)
    if errors:
        return JsonResponse(
            {'variants': {}},
            status=400,
            content_type="application/json; charset=utf-8"
        )

    pm_variants = get_pm_variants(**query)
    return JsonResponse(PMVariantsResponseSchema().dump({'pm_variants': pm_variants}).data)
