# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging
import requests
from django.conf import settings

from common.data_api.travel_api.instance import travel_api
from travel.rasp.library.python.api_clients.travel_api.client import TravelApiUserIdent
from travel.rasp.library.python.common23.models.core.geo.settlement import Settlement
from travel.rasp.library.python.common23.models.core.geo.station import Station


log = logging.getLogger(__name__)


HOTELS_BANNER_TYPE = 'yaTravelHotels'
BLABLACAR_BANNER_TYPE = 'bla_bla_car'
ADVERTISING_BANNER_TYPE = 'advertising'


def build_advertising_result():
    return {
        'banner_type': ADVERTISING_BANNER_TYPE,
        'data': None
    }


def build_hotels_result(settlement, does_landing_exist=False):
    slug = settlement.slug
    region = settlement.L_title(case='locative', fallback=False)
    geo_id = settlement._geo_id
    return {
        'banner_type': HOTELS_BANNER_TYPE,
        'data': {
            'slug': slug,
            'does_landing_exist': does_landing_exist,
            'region': region,
            'geo_id': geo_id
        }
    }


def get_hotels_banner_info(context):
    """
    :type context: morda_backend.data_layer.search.backend.SearchContext
    """

    if not settings.ENABLE_HOTEL_BANNER:
        return None

    point = context.point_to
    settlement = None

    if isinstance(point, Settlement):
        settlement = point
    elif isinstance(point, Station):
        settlement = point.settlement

    if not settlement:
        return None

    does_landing_exist = False
    if settlement.slug:
        user_ident = TravelApiUserIdent(session_id='morda_backend_session_key')

        try:
            does_landing_exist = travel_api.does_hotel_city_static_page_exist(user_ident, settlement._geo_id)
        except requests.HTTPError as ex:
            log.exception('Error in Travel API response with content: ' + ex.response.content)
        except Exception:
            log.exception('Error during request does_hotel_city_static_page_exist')

    return build_hotels_result(settlement=settlement, does_landing_exist=does_landing_exist)


EXPERIMENTS_BANNER_TYPE_BY_PRIORITY = [
    ('banner_hotels', get_hotels_banner_info),
    # ('banner_blablacar', ) пока не используется https://st.yandex-team.ru/TRAVELORGANIC-229
]


def get_banner_info(context):
    for banner, banner_function in EXPERIMENTS_BANNER_TYPE_BY_PRIORITY:
        if banner in context.exps_flags:
            result = banner_function(context)

            if result is not None:
                return result

    return build_advertising_result()
