# coding: utf8
from __future__ import unicode_literals

from django.utils.translation import get_language

from common.models.transport import TransportType
from common.views.teasers import TeaserSetRasp, TeaserSetMobile

from travel.rasp.morda_backend.morda_backend.search.search.data_layer.avia_segments import SearchAviaSegment


def get_teasers(context, segments):
    """
    :type context: morda_backend.data_layer.search.backend.SearchContext
    :type segments: list[route_search.models.RThreadSegment] |
     list[route_search.models.RThreadSegmentGroup] |
     list[route_search.models.IntervalRThreadSegment] |
     list[route_search.models.AllDaysRThreadSegment]
    """
    logic_pages = [context.transport_type == 'suburban' and 'search_suburban' or 'search']

    flat_segments = [ps for s in segments for ps in getattr(s, 'segments', [s])]

    t_type_ids = set()
    for segment in flat_segments:
        t_type_id = TransportType.PLANE_ID if isinstance(segment, SearchAviaSegment) else segment.thread.t_type_id
        t_type_ids.add(t_type_id)

    filtered_segments = [s for s in flat_segments if not isinstance(s, SearchAviaSegment)]

    if TransportType.TRAIN_ID in t_type_ids:
        logic_pages.append('search_trains')
    if TransportType.PLANE_ID in t_type_ids:
        logic_pages.append('search_planes')
    # FIXME: следующие условия странные, но реализовано было именно так в старой морде.
    if TransportType.TRAIN_ID in t_type_ids and TransportType.PLANE_ID not in t_type_ids:
        logic_pages.append('search_trains_only')
    if TransportType.PLANE_ID in t_type_ids and TransportType.TRAIN_ID not in t_type_ids:
        logic_pages.append('search_planes_only')

    teaser_set_cls = TeaserSetMobile if context.is_mobile else TeaserSetRasp
    selected_teasers = teaser_set_cls(None, logic_pages, {
        'points': [context.point_from, context.point_to],
        'routes': filtered_segments,
    }, national_version=context.national_version, language=get_language()).selected

    return {
        teaser_type: teaser
        for teaser_type, teaser in selected_teasers.items()
    }
