# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields

from common.serialization.fields import DictNestedField
from travel.rasp.morda_backend.morda_backend.serialization.segment import BaseSearchSegmentDaysSchema
from travel.rasp.morda_backend.morda_backend.search.canonicals.serialization import CanonicalSchema


class ArchivalStationSchema(Schema):
    id = fields.Integer()
    title = fields.String()


class ArchivalThreadSchema(Schema):
    begin_time = fields.String(dump_to='beginTime')
    end_time = fields.String(dump_to='endTime')
    density = fields.String()
    number = fields.String()


class ArchivalTransportSubtypeSchema(Schema):
    id = fields.Integer()
    code = fields.String()
    title = fields.String()
    color = fields.String(dump_to='titleColor')


class ArchivalTransportSchema(Schema):
    id = fields.Integer()
    title = fields.String()
    code = fields.String()
    subtype = fields.Nested(ArchivalTransportSubtypeSchema)


class ArchivalSegmentSchema(Schema):
    title = fields.String()
    arrival = fields.DateTime()
    departure = fields.DateTime()
    station_from = fields.Nested(ArchivalStationSchema, dump_to='stationFrom')
    station_to = fields.Nested(ArchivalStationSchema, dump_to='stationTo')
    transport_type = fields.Nested(ArchivalTransportSchema, dump_to='transport')
    thread = fields.Nested(ArchivalThreadSchema)
    run_days_by_tz = DictNestedField(BaseSearchSegmentDaysSchema, dump_to='daysByTimezone')


class ArchivalDataSchema(Schema):
    canonical = fields.Nested(CanonicalSchema)
    transport_types = fields.List(fields.String(), dump_to='transportTypes')
    segments = fields.Nested(ArchivalSegmentSchema, many=True)
