# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields

from common.serialization.fields import DictNestedField

from travel.rasp.morda_backend.morda_backend.serialization.segment import (
    BaseSegmentSchema, BaseThreadSchema, BaseSearchSegmentDaysSchema, SearchCompanySchema
)
from travel.rasp.morda_backend.morda_backend.serialization.segment_transport import TransportModelSchema
from travel.rasp.morda_backend.morda_backend.serialization.segment_station import SegmentStationSchema


class AviaTransportSchema(Schema):
    id = fields.Integer()
    code = fields.String()
    title = fields.String()
    model = fields.Nested(TransportModelSchema)


class AviaThreadSchema(BaseThreadSchema):
    title = fields.String()

    # Должны присутствовать в ответе, несмотря на то, что не имеют смысла для авиа
    schedule_plan = fields.String(dump_to='schedulePlanCode')
    is_basic = fields.Boolean(dump_to='isBasic')
    displace_yabus = fields.Boolean(dump_to='displaceYabus')
    has_train_tariffs = fields.Boolean(dump_to='hasTrainTariffs')


class AviaSegmentSchema(BaseSegmentSchema):
    title = fields.String()
    station_from = fields.Nested(SegmentStationSchema, dump_to='stationFrom')
    station_to = fields.Nested(SegmentStationSchema, dump_to='stationTo')

    thread = fields.Nested(AviaThreadSchema)
    transport = fields.Nested(AviaTransportSchema)
    days_by_tz = DictNestedField(BaseSearchSegmentDaysSchema, dump_to='daysByTimezone')

    # Должны присутствовать в ответе, несмотря на то, что неимеют смысла для авиа
    is_interval = fields.Boolean(dump_to='isInterval')
    is_through_train = fields.Boolean(dump_to='isThroughTrain')
    stops = fields.String()


class AviaSearchCodeshareSchema(Schema):
    number = fields.String()
    tariffs_keys = fields.List(fields.String, dump_to='tariffsKeys')
    company = fields.Nested(SearchCompanySchema)


class AviaSearchSegmentSchema(AviaSegmentSchema):
    tariffs_keys = fields.List(fields.String, dump_to='tariffsKeys')
    codeshares = fields.Nested(AviaSearchCodeshareSchema, many=True)
