# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields

from travel.rasp.morda_backend.morda_backend.search.canonicals.serialization import CanonicalSchema
from travel.rasp.morda_backend.morda_backend.search.search.serialization.archival_data_serialization import (
    ArchivalDataSchema
)
from travel.rasp.morda_backend.morda_backend.search.search.serialization.avia_response_serialization import (
    AviaSearchSegmentSchema
)
from travel.rasp.morda_backend.morda_backend.search.search.data_layer.avia_segments import SearchAviaSegment
from travel.rasp.morda_backend.morda_backend.serialization.fields import AwareDateTime
from travel.rasp.morda_backend.morda_backend.serialization.segment import (
    RaspDBSearchMainSegmentSchema, TrainSchedulePlanSchema
)
from travel.rasp.morda_backend.morda_backend.serialization.teasers import SelectedTeasers


class ResponseSearchPointSchema(Schema):
    point_key = fields.String(dump_to='key')
    title = fields.Function(lambda obj: obj.L_title())
    title_with_type = fields.Function(lambda obj: obj.L_title_with_type(), dump_to='titleWithType')
    title_genitive = fields.Function(lambda obj: obj.L_title(case='genitive', fallback=False), dump_to='titleGenitive')
    title_accusative = fields.Function(lambda obj: obj.L_title(case='accusative', fallback=False),
                                       dump_to='titleAccusative')
    title_locative = fields.Function(lambda obj: obj.L_title(case='locative', fallback=False), dump_to='titleLocative')
    preposition_v_vo_na = fields.Function(lambda obj: obj.L_title(case='preposition_v_vo_na', fallback=False),
                                          dump_to='preposition')
    popular_title = fields.Function(lambda obj: obj.L_popular_title(fallback=False), dump_to='popularTitle')
    short_title = fields.Function(lambda obj: obj.L_short_title(fallback=False), dump_to='shortTitle')
    slug = fields.String()


class ResponseSearchPointsSchema(Schema):
    nearest = fields.Boolean(default=False)
    point_from = fields.Nested(ResponseSearchPointSchema, dump_to="pointFrom")
    point_to = fields.Nested(ResponseSearchPointSchema, dump_to="pointTo")


class ResponseContextSchema(Schema):
    is_changed = fields.Boolean(default=False, dump_to='isChanged')
    original = fields.Nested(ResponseSearchPointsSchema)
    search = fields.Nested(ResponseSearchPointsSchema)
    transport_types = fields.List(fields.String(), dump_to='transportTypes')
    latest_datetime = AwareDateTime(dump_to='latestDatetime')


class PlansSchema(Schema):
    current = fields.Nested(TrainSchedulePlanSchema)
    next = fields.Nested(TrainSchedulePlanSchema)


class BannerInfoDataSchema(Schema):
    slug = fields.String()
    does_landing_exist = fields.Boolean(dump_to='doesLandingExist')
    region = fields.String()
    geo_id = fields.Integer(dump_to='geoId')


class BannerInfoSchema(Schema):
    banner_type = fields.String(dump_to='bannerType')
    data = fields.Nested(BannerInfoDataSchema)


class ResponseSchema(Schema):
    context = fields.Nested(ResponseContextSchema)
    plans = fields.Nested(PlansSchema)
    segments = fields.Method('_make_segments')
    teasers = fields.Nested(SelectedTeasers)
    canonical = fields.Nested(CanonicalSchema)
    archival_data = fields.Nested(ArchivalDataSchema, dump_to='archivalData')
    banner_info = fields.Nested(BannerInfoSchema, dump_to='bannerInfo')

    def _make_segments(self, response):
        segments = []
        for segment in response['segments']:
            if isinstance(segment, SearchAviaSegment):
                data, _ = AviaSearchSegmentSchema(context=self.context).dump(segment)
                segments.append(data)
            else:
                data, _ = RaspDBSearchMainSegmentSchema(context=self.context).dump(segment)
                segments.append(data)
        return segments
