# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from common.models.transport import TransportType
from route_search import shortcuts

from travel.rasp.morda_backend.morda_backend.search.merge_trains import (
    fill_train_numbers, make_meta_trains, get_possible_numbers
)


def get_train_segment(query):
    departure = query.point_from.pytz.localize(query.departure)
    segments, nears, tts = shortcuts.search_routes(
        query.point_from,
        query.point_to,
        departure_date=departure.date(),
        transport_types=[TransportType.objects.get(pk=TransportType.TRAIN_ID)],
        check_date=None,
        include_interval=False,
        add_z_tablos=False
    )
    fill_train_numbers(segments)
    segments = make_meta_trains(segments)

    segment = next(
        (s for s in segments if query.number in get_possible_numbers(s) and s.departure == departure),
        None
    )
    return segment
