# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import fields, post_load

from common.utils.namedtuple import namedtuple_with_defaults
from common.serialization.schema import get_defaults_from_schema

from travel.rasp.morda_backend.morda_backend.serialization.schema_bases import PointsQuerySchema


class TrainSegmentQuerySchema(PointsQuerySchema):
    number = fields.String(required=True)
    national_version = fields.String(default='ru')
    departure = fields.DateTime(required=True)

    @post_load
    def make_query(self, data):
        return TrainSegmentQuery(**data)


class TrainSegmentQuery(namedtuple_with_defaults('OrderSegmentQuery',
                                                 TrainSegmentQuerySchema().fields.keys(),
                                                 get_defaults_from_schema(TrainSegmentQuerySchema))):
    pass
