# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from rest_framework import status
from rest_framework.decorators import api_view
from rest_framework.response import Response

from travel.rasp.morda_backend.morda_backend.search.train_segment.data_layer import get_train_segment
from travel.rasp.morda_backend.morda_backend.search.segment import (
    fill_thread_first_last_country_code, fill_express_codes_for_segments
)
from travel.rasp.morda_backend.morda_backend.search.train_segment.serialization import TrainSegmentQuerySchema
from travel.rasp.morda_backend.morda_backend.serialization.segment import RaspDBSegmentSchema


@api_view(['GET'])
def train_segment(request):
    """
    Возвращает сегмент для отображения страницы заказа.
    """
    query, errors = TrainSegmentQuerySchema().load(request.GET)
    if errors:
        return Response({
            'errors': errors
        }, status=status.HTTP_400_BAD_REQUEST)

    segment = get_train_segment(query)
    if not segment:
        return Response({
            'errors': {'wrongRequest': ['no_such_segment']}
        }, status=status.HTTP_400_BAD_REQUEST)

    segment_list = [segment]
    fill_thread_first_last_country_code(segment_list)
    fill_express_codes_for_segments(segment_list)
    return Response({'result': RaspDBSegmentSchema().dump(segment).data})
