# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from common.models.schedule import TrainPurchaseNumber, RThread
from route_search.transfers.transfers import get_transfer_variants


log = logging.getLogger(__name__)


def _fill_train_numbers(variants):
    threads = []
    for variant in variants:
        for segment in variant.segments:
            if isinstance(segment.thread, RThread):
                threads.append(segment.thread)

    numbers_by_thread = TrainPurchaseNumber.get_train_purchase_numbers(threads)
    for variant in variants:
        for segment in variant.segments:
            if isinstance(segment.thread, RThread):
                segment.train_numbers = numbers_by_thread.get(segment.thread.id)


def get_transfers_variants(point_from, point_to, when, transport_types=None):
    if transport_types:
        transport_types = [t.code for t in transport_types]
    variants = list(get_transfer_variants(point_from, point_to, when, transport_types))

    _fill_train_numbers(variants)

    return variants
