# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

import logging

from travel.rasp.morda_backend.morda_backend.data_layer.decorators import json_response
from travel.rasp.morda_backend.morda_backend.search.transfers.serialization import (
    TransfersVariantsQuerySchema, TransfersVariantsResponseSchema
)
from travel.rasp.morda_backend.morda_backend.search.transfers.service import get_transfers_variants


log = logging.getLogger(__name__)


@json_response
def variants(request):
    """
    Поиск варианта проезда с пересадками.
    Примеры запросов:
        /ru/search/transfers/?pointFrom=c54&pointTo=c50&when=2016-04-25&transportType=suburban
        /ru/search/transfers/?pointFrom=c54&pointTo=c50&when=2016-04-25
    """
    query, errors = TransfersVariantsQuerySchema().load(request.GET)
    if errors:
        return {
            'errors': errors
        }

    transfers_variants = get_transfers_variants(**query)
    return TransfersVariantsResponseSchema().dump({
        'transfers_variants': transfers_variants
    }).data
