# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields

from travel.rasp.morda_backend.morda_backend.search.parse_context.point import get_point_timezone


class CountrySchema(Schema):
    id = fields.Integer()
    code = fields.String()


class SegmentStationCodesSchema(Schema):
    express = fields.String()


class SegmentStationSchema(Schema):
    id = fields.Integer()
    title = fields.Function(lambda obj: obj.L_title())
    popular_title = fields.Function(lambda obj: obj.L_popular_title(), dump_to='popularTitle')
    settlement_id = fields.Integer(dump_to='settlementId')
    timezone = fields.Function(lambda s: get_point_timezone(s))
    country = fields.Method('_dump_country')
    codes = fields.Nested(SegmentStationCodesSchema)
    page_type = fields.Function(lambda s: s.page_type, dump_to='pageType')
    main_subtype = fields.Function(lambda s: s.main_subtype, dump_to='mainSubtype')

    def _dump_country(self, station):
        if station.country_id is not None:
            return CountrySchema().dump(station.country).data
