# coding: utf-8

from marshmallow import Schema, fields


class SuburbanFacilitySchema(Schema):
    code = fields.String()
    title = fields.Function(lambda obj: obj.L_title())
    icon = fields.Method(serialize='get_icon_url')

    def get_icon_url(self, obj):
        """
        :type obj: common.apps.facility.models.SuburbanFacility
        :return: str | None
        """

        return obj.icon.name and obj.icon.url
