# -*- coding: utf-8 -*-

from marshmallow import Schema, fields, missing

from common.models.transport import TransportType, TransportSubtype


class TransportModelSchema(Schema):
    title = fields.Function(lambda obj: obj.L_title())


class TransportSubTypeSchema(Schema):
    id = fields.Integer()
    code = fields.String()
    title = fields.Function(lambda obj: obj.L_title())
    title_color = fields.Method('get_title_color', dump_to='titleColor')

    def get_title_color(self, obj):
        color = obj.color
        return missing if color is None else color.color


class TransportSubTypeTrainSuburbanSchema(TransportSubTypeSchema):
    title = fields.Function(lambda obj: obj.L_title_suburban())


class DeluxeTrainSchema(Schema):
    id = fields.Integer()
    title = fields.Function(lambda obj: obj.L_title())
    short_title = fields.Function(lambda obj: obj.L_title_short(), dump_to='shortTitle')
    is_deluxe = fields.Boolean(attribute='deluxe', dump_to='isDeluxe', default=False)
    is_high_speed = fields.Boolean(attribute='high_speed', dump_to='isHighSpeed', default=False)
    page_path = fields.String(dump_to='pagePath')


def build_transport(segment, request_t_type=None):
    t_type = segment.t_type
    t_subtype = segment.thread and segment.thread.t_subtype
    rtstation_from = getattr(segment, 'rtstation_from', None)
    t_model = rtstation_from and rtstation_from.departure_t_model or getattr(segment, 't_model', None)

    transport_data = {
        'id': t_type.id,
        'code': t_type.code,
        'title': t_type.L_title(),
    }
    if t_model:
        transport_data['model'] = TransportModelSchema().dump(t_model).data
    if t_subtype:
        if request_t_type == TransportType.get_suburban_type().code and t_subtype.code in TransportSubtype.get_train_search_codes():
            transport_data['subtype'] = TransportSubTypeTrainSuburbanSchema().dump(t_subtype).data
        else:
            transport_data['subtype'] = TransportSubTypeSchema().dump(t_subtype).data
    return transport_data
