# -*- coding: utf-8 -*-

from marshmallow import Schema, fields
from marshmallow.decorators import post_dump


def teaser_json(teaser):
    return TeaserSchema().dump(teaser)[0]


class TeaserSchema(Schema):
    id = fields.Integer()
    importance = fields.Integer()
    title = fields.String()
    content = fields.String()
    mobile_content = fields.String(dump_to='mobileContent')
    url = fields.String()
    image_url = fields.Method('get_image_url', dump_to='imageUrl')

    def get_image_url(self, obj):
        return obj.image.url if obj.image else None

    @post_dump
    def post_dump(self, data):
        data['image_url'] = data['imageUrl']
        return data


class SelectedTeasers(Schema):
    normal = fields.Nested(TeaserSchema)
    attention = fields.Nested(TeaserSchema, attribute='ahtung')
    special = fields.Nested(TeaserSchema)
    banner = fields.Nested(TeaserSchema)
