# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from django.conf import settings
from django.core.cache import cache
from django.utils import translation

from common.models.transport import TransportType
from travel.rasp.morda_backend.morda_backend.data_layer.popular_directions import get_point_popular_directions


def get_settlement_transport_popular_directions(settlement, t_type_code, limit):
    """
    Возвращает популярные направления для страницы город-транспорт
    """
    lang = str(translation.get_language())
    cache_key = settings.CACHEROOT + '/settlement_transport/popular_directions' + settlement.point_key + t_type_code + lang
    cached_response = cache.get(cache_key)
    if cached_response:
        return cached_response

    from_directions, to_directions = _get_popular_directions(settlement, t_type_code, limit)

    from_segments = [
        {'point_from': segment.inner_point, 'point_to': segment.outer_point}
        for segment in from_directions
    ]
    to_segments = [
        {'point_from': segment.outer_point, 'point_to': segment.inner_point}
        for segment in to_directions
    ]

    data = {
        'from_settlement': from_segments,
        'to_settlement': to_segments,
    }
    cache.set(cache_key, data, settings.CACHES['default']['LONG_TIMEOUT'])

    return data


def get_settlement_popular_directions(settlement):
    """
    Возвращает популярные направления для страницы города
    """
    lang = str(translation.get_language())
    cache_key = settings.CACHEROOT + '/settlement/popular_directions' + settlement.point_key + lang
    cached_response = cache.get(cache_key)
    if cached_response:
        return cached_response

    from_directions, to_directions = _get_popular_directions(settlement, t_type_code=None, limit=5)

    data = {
        'directions_from': {
            'title': settlement.L_title_phrase_from(),
            'points': _get_popular_points(from_directions)
        },
        'directions_to': {
            'title': settlement.L_title_phrase_to(),
            'points': _get_popular_points(to_directions)
        }
    }
    cache.set(cache_key, data, settings.CACHES['default']['LONG_TIMEOUT'])

    return data


def _get_popular_points(directions):
    popular_points = []
    for direction in directions:
        popular_point = direction.outer_point
        popular_point.inner_slug = direction.inner_point.slug
        if direction.t_type:
            popular_point.t_type = direction.t_type.code
        popular_points.append(popular_point)

    return popular_points


def _get_popular_directions(settlement, t_type_code, limit):
    t_type = TransportType.objects.get(code=t_type_code) if t_type_code else None
    from_directions = get_point_popular_directions('from', settlement, t_type, limit, 'c')
    to_directions = get_point_popular_directions('to', settlement, t_type, limit, 'c')
    return from_directions, to_directions
