# coding: utf-8
from __future__ import unicode_literals, absolute_import, division, print_function


def to_int(value):
    if isinstance(value, int):
        return value

    if not value:
        return None

    if isinstance(value, basestring):
        try:
            return int(float(value))
        except ValueError:
            return None

    try:
        return int(value)
    except (ValueError, TypeError):
        return None


def get_national_version(request):
    return request.GET.get('national_version') or 'ru'


def get_int_param_value(request, param_name):
    return to_int(request.GET.get(param_name))


def get_int_list_param_value(request, param_name):
    values = request.GET.get(param_name)
    if values is None:
        return None

    values = values.split(',')
    values = [to_int(value) for value in values]
    values = [value for value in values if value is not None]

    return values
