# -*- coding: utf-8 -*-

from __future__ import unicode_literals

from common.models.geo import Settlement, Country

_SAMPLES_DICT = {
    Country.RUSSIA_ID: ('c213', 'c2'),  # Москва - СПб
    Country.UKRAINE_ID: ('c143', 'c144'),  # Киев - Львов
    Country.BELARUS_ID: ('c157', 'c158'),  # Минск - Могилёв
    Country.KAZAKHSTAN_ID: ('c163', 'c22177'),  # Астана - Алматы
    Country.UZBEKISTAN_ID: ('c10335', 'c10334')  # Ташкент - Самарканд
}


def get_search_sample_points_keys(settlement_id, national_version):
    """
    Получает пару кодов городов/станций для построения примера поискового контекста.
    Если переданный город находится за пределами зоны КУБР, возвращается результат для России.
    :param settlement_id: ID города пользователя.
    :param national_version: национальная версия: 'ru', 'ua' - используется
                             для нахождения страны города на спорной территории.
    :return: пара кодов, например: ('c213', 'c2') - соответствует поисковому запросу Москва - Санкт-Петербург.
    """
    country_id = get_country_id_for_search_sample_points(settlement_id, national_version)
    return _SAMPLES_DICT[country_id]


def get_country_id_for_search_sample_points(settlement_id, national_version):
    """
    Получает ID страны для построения примера поискового контекста.
    Если переданный город находится за пределами зоны КУБР, возвращается Россиия.
    :param settlement_id: ID города пользователя.
    :param national_version: национальная версия: 'ru', 'ua' - используется
                             для нахождения страны города на спорной территории.
    :return: Country.id
    """
    settlement = Settlement.objects.get(id=settlement_id)
    country = settlement.translocal_country(national_version)
    if country and country.id in _SAMPLES_DICT:
        return country.id
    else:
        return Country.objects.get(domain_zone=national_version).id
