# coding: utf8
from __future__ import unicode_literals, absolute_import, division, print_function

from marshmallow import Schema, fields


class TransportPopularDirectionsRequestSchema(Schema):
    t_type = fields.String()
    limit = fields.Integer(default=10)


class PopularPointSchema(Schema):
    point_key = fields.String(dump_to='key')
    title = fields.String()
    slug = fields.String()


class PopularSegmentSchema(Schema):
    point_from = fields.Nested(PopularPointSchema, dump_to='from')
    point_to = fields.Nested(PopularPointSchema, dump_to='to')


class TransportPopularDirectionsSchema(Schema):
    from_settlement = fields.Nested(PopularSegmentSchema, dump_to='fromSettlement', many=True)
    to_settlement = fields.Nested(PopularSegmentSchema, dump_to='toSettlement', many=True)


class AllTransportsPopularSettlementSchema(PopularPointSchema):
    id = fields.Integer()
    title_phrase = fields.String(dump_to='directionTitle')
    inner_slug = fields.String(dump_to='innerSlug')
    t_type = fields.String(dump_to='transportType')


class AllTransportsPopularDirectionSchema(Schema):
    title = fields.String()
    points = fields.Nested(AllTransportsPopularSettlementSchema, many=True)


class AllTransportsPopularDirectionsSchema(Schema):
    directions_from = fields.Nested(AllTransportsPopularDirectionSchema, dump_to='from')
    directions_to = fields.Nested(AllTransportsPopularDirectionSchema, dump_to='to')
